/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.lifecycle.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.LevelChunk;

public final class ServerChunkEvents {
    public static final Event<Load> CHUNK_LOAD = EventFactory.createArrayBacked(Load.class, callbacks -> (serverWorld, chunk) -> {
        for (Load callback : callbacks) {
            callback.onChunkLoad(serverWorld, chunk);
        }
    });
    public static final Event<Generate> CHUNK_GENERATE = EventFactory.createArrayBacked(Generate.class, callbacks -> (serverWorld, chunk) -> {
        for (Generate callback : callbacks) {
            callback.onChunkGenerate(serverWorld, chunk);
        }
    });
    public static final Event<Unload> CHUNK_UNLOAD = EventFactory.createArrayBacked(Unload.class, callbacks -> (serverWorld, chunk) -> {
        for (Unload callback : callbacks) {
            callback.onChunkUnload(serverWorld, chunk);
        }
    });
    public static final Event<LevelTypeChange> CHUNK_LEVEL_TYPE_CHANGE = EventFactory.createArrayBacked(LevelTypeChange.class, (world, chunk, oldLevelType, newLevelType) -> {}, callbacks -> (serverWorld, chunk, oldLevelType, newLevelType) -> {
        for (LevelTypeChange callback : callbacks) {
            callback.onChunkLevelTypeChange(serverWorld, chunk, oldLevelType, newLevelType);
        }
    });

    private ServerChunkEvents() {
    }

    @FunctionalInterface
    public static interface LevelTypeChange {
        public void onChunkLevelTypeChange(ServerLevel var1, LevelChunk var2, FullChunkStatus var3, FullChunkStatus var4);
    }

    @FunctionalInterface
    public static interface Unload {
        public void onChunkUnload(ServerLevel var1, LevelChunk var2);
    }

    @FunctionalInterface
    public static interface Generate {
        public void onChunkGenerate(ServerLevel var1, LevelChunk var2);
    }

    @FunctionalInterface
    public static interface Load {
        public void onChunkLoad(ServerLevel var1, LevelChunk var2);
    }
}

