/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.impl.event.lifecycle.ChunkLevelTypeEventTracker;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatusTasks;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkStatusTasks.class})
abstract class ChunkStatusTasksMixin {
    @Unique
    private static final FullChunkStatus[] fabric_CHUNK_LEVEL_TYPES = FullChunkStatus.values();

    ChunkStatusTasksMixin() {
    }

    @Inject(method={"lambda$full$0"}, at={@At(value="TAIL")})
    private static void onChunkLoad(ChunkAccess chunk, WorldGenContext chunkGenerationContext, GenerationChunkHolder chunkHolder, CallbackInfoReturnable<ChunkAccess> callbackInfoReturnable) {
        LevelChunk worldChunk = (LevelChunk)callbackInfoReturnable.getReturnValue();
        ((ServerChunkEvents.Load)ServerChunkEvents.CHUNK_LOAD.invoker()).onChunkLoad(chunkGenerationContext.level(), worldChunk);
        if (!(chunk instanceof ImposterProtoChunk)) {
            ((ServerChunkEvents.Generate)ServerChunkEvents.CHUNK_GENERATE.invoker()).onChunkGenerate(chunkGenerationContext.level(), worldChunk);
        }
        ChunkLevelTypeEventTracker levelTypeTracker = (ChunkLevelTypeEventTracker)chunkHolder;
        for (int i = levelTypeTracker.fabric_getCurrentEventLevelType().ordinal(); i < chunkHolder.getFullStatus().ordinal(); ++i) {
            FullChunkStatus oldLevelType = fabric_CHUNK_LEVEL_TYPES[i];
            FullChunkStatus newLevelType = fabric_CHUNK_LEVEL_TYPES[i + 1];
            ((ServerChunkEvents.LevelTypeChange)ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.invoker()).onChunkLevelTypeChange(chunkGenerationContext.level(), worldChunk, oldLevelType, newLevelType);
            levelTypeTracker.fabric_setCurrentEventLevelType(newLevelType);
        }
    }
}

