/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.loot;

import java.util.Collection;
import java.util.List;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import net.fabricmc.fabric.api.loot.v2.FabricLootPoolBuilder;
import net.minecraft.class_117;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_79;

/**
 * The implementation of the injected interface {@link FabricLootPoolBuilder}.
 * Simply implements the new methods by adding the relevant objects inside the lists.
 */
@Mixin(class_55.class_56.class)
abstract class LootPoolBuilderMixin implements FabricLootPoolBuilder {
	@Shadow
	@Final
	private List<class_79> entries;

	@Shadow
	@Final
	private List<class_5341> conditions;

	@Shadow
	@Final
	private List<class_117> functions;

	@Unique
	private class_55.class_56 self() {
		// noinspection ConstantConditions
		return (class_55.class_56) (Object) this;
	}

	@Override
	public class_55.class_56 with(class_79 entry) {
		this.entries.add(entry);
		return self();
	}

	@Override
	public class_55.class_56 with(Collection<? extends class_79> entries) {
		this.entries.addAll(entries);
		return self();
	}

	@Override
	public class_55.class_56 conditionally(class_5341 condition) {
		this.conditions.add(condition);
		return self();
	}

	@Override
	public class_55.class_56 conditionally(Collection<? extends class_5341> conditions) {
		this.conditions.addAll(conditions);
		return self();
	}

	@Override
	public class_55.class_56 apply(class_117 function) {
		this.functions.add(function);
		return self();
	}

	@Override
	public class_55.class_56 apply(Collection<? extends class_117> functions) {
		this.functions.addAll(functions);
		return self();
	}
}
