/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.loot;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import net.fabricmc.fabric.api.loot.v2.FabricLootPoolBuilder;
import net.fabricmc.fabric.api.loot.v2.FabricLootTableBuilder;
import net.minecraft.class_117;
import net.minecraft.class_52;
import net.minecraft.class_55;

/**
 * The implementation of the injected interface {@link FabricLootTableBuilder}.
 * Simply implements the new methods by adding the relevant objects inside the lists.
 */
@Mixin(class_52.class_53.class)
abstract class LootTableBuilderMixin implements FabricLootTableBuilder {
	@Shadow
	@Final
	private List<class_55> pools;

	@Shadow
	@Final
	private List<class_117> functions;

	@Unique
	private class_52.class_53 self() {
		// noinspection ConstantConditions
		return (class_52.class_53) (Object) this;
	}

	@Override
	public class_52.class_53 pool(class_55 pool) {
		this.pools.add(pool);
		return self();
	}

	@Override
	public class_52.class_53 apply(class_117 function) {
		this.functions.add(function);
		return self();
	}

	@Override
	public class_52.class_53 pools(Collection<? extends class_55> pools) {
		this.pools.addAll(pools);
		return self();
	}

	@Override
	public class_52.class_53 apply(Collection<? extends class_117> functions) {
		this.functions.addAll(functions);
		return self();
	}

	@Override
	public class_52.class_53 modifyPools(Consumer<? super class_55.class_56> modifier) {
		ListIterator<class_55> iterator = pools.listIterator();

		while (iterator.hasNext()) {
			class_55.class_56 poolBuilder = FabricLootPoolBuilder.copyOf(iterator.next());
			modifier.accept(poolBuilder);
			iterator.set(poolBuilder.method_355());
		}

		return self();
	}
}
