/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.loot;

import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.loot.v2.FabricLootTableBuilder;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.impl.loot.LootUtil;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7924;
import net.minecraft.class_8490;
import net.minecraft.class_9383;

/**
 * Implements the events from {@link LootTableEvents}.
 */
@Mixin(class_9383.class)
abstract class ReloadableRegistriesMixin {
	@ModifyArg(method = "method_58286", at = @At(value = "INVOKE", target = "Lnet/minecraft/registry/MutableRegistry;add(Lnet/minecraft/registry/RegistryKey;Ljava/lang/Object;Lnet/minecraft/registry/entry/RegistryEntryInfo;)Lnet/minecraft/registry/entry/RegistryEntry$Reference;"), index = 1)
	private static Object modifyLootTable(Object value, @Local(argsOnly = true) class_2960 id) {
		if (!(value instanceof class_52 table)) return value;

		if (table == class_52.field_948) {
			// This is a special table and cannot be modified.
			return value;
		}

		class_5321<class_52> key = class_5321.method_29179(class_7924.field_50079, id);
		// Populated inside JsonDataLoaderMixin
		LootTableSource source = LootUtil.SOURCES.get().getOrDefault(id, LootTableSource.DATA_PACK);
		// Invoke the REPLACE event for the current loot table.
		class_52 replacement = LootTableEvents.REPLACE.invoker().replaceLootTable(key, table, source);

		if (replacement != null) {
			// Set the loot table to MODIFY to be the replacement loot table.
			// The MODIFY event will also see it as a replaced loot table via the source.
			table = replacement;
			source = LootTableSource.REPLACED;
		}

		// Turn the current table into a modifiable builder and invoke the MODIFY event.
		class_52.class_53 builder = FabricLootTableBuilder.copyOf(table);
		LootTableEvents.MODIFY.invoker().modifyLootTable(key, builder, source);

		return builder.method_338();
	}

	@SuppressWarnings("unchecked")
	@Inject(method = "method_58279", at = @At("RETURN"))
	private static void onLootTablesLoaded(class_8490 lootDataType, class_3300 resourceManager, class_6903 registryOps, CallbackInfoReturnable<class_2385> cir) {
		if (lootDataType != class_8490.field_44498) return;

		LootTableEvents.ALL_LOADED.invoker().onLootTablesLoaded(resourceManager, (class_2378<class_52>) cir.getReturnValue());
		LootUtil.SOURCES.remove();
	}
}
