/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.loot;

import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import net.fabricmc.fabric.api.loot.v3.FabricLootPoolBuilder;
import net.minecraft.class_117;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_79;

/**
 * Accesses loot pool fields for {@link FabricLootPoolBuilder#copyOf(class_55)}.
 * These are normally available in the transitive access widener module.
 */
@Mixin(class_55.class)
public interface LootPoolAccessor {
	@Accessor("rolls")
	class_5658 fabric_getRolls();

	@Accessor("bonusRolls")
	class_5658 fabric_getBonusRolls();

	@Accessor("entries")
	List<class_79> fabric_getEntries();

	@Accessor("conditions")
	List<class_5341> fabric_getConditions();

	@Accessor("functions")
	List<class_117> fabric_getFunctions();
}
