/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.loot.v3;

import java.util.Collection;

import org.jetbrains.annotations.ApiStatus;
import net.fabricmc.fabric.mixin.loot.LootPoolAccessor;
import net.minecraft.class_117;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_79;

/**
 * Convenience extensions to {@link class_55.class_56}
 * for adding pre-built objects or collections.
 *
 * <p>This interface is automatically injected to {@link class_55.class_56}.
 */
@ApiStatus.NonExtendable
public interface FabricLootPoolBuilder {
	/**
	 * Adds an entry to this builder.
	 *
	 * @param entry the added loot entry
	 * @return this builder
	 */
	default class_55.class_56 with(class_79 entry) {
		throw new UnsupportedOperationException("Implemented via mixin");
	}

	/**
	 * Adds entries to this builder.
	 *
	 * @param entries the added loot entries
	 * @return this builder
	 */
	default class_55.class_56 with(Collection<? extends class_79> entries) {
		throw new UnsupportedOperationException("Implemented via mixin");
	}

	/**
	 * Adds a condition to this builder.
	 *
	 * @param condition the added condition
	 * @return this builder
	 */
	default class_55.class_56 conditionally(class_5341 condition) {
		throw new UnsupportedOperationException("Implemented via mixin");
	}

	/**
	 * Adds conditions to this builder.
	 *
	 * @param conditions the added conditions
	 * @return this builder
	 */
	default class_55.class_56 conditionally(Collection<? extends class_5341> conditions) {
		throw new UnsupportedOperationException("Implemented via mixin");
	}

	/**
	 * Applies a function to this builder.
	 *
	 * @param function the applied loot function
	 * @return this builder
	 */
	default class_55.class_56 apply(class_117 function) {
		throw new UnsupportedOperationException("Implemented via mixin");
	}

	/**
	 * Applies loot functions to this builder.
	 *
	 * @param functions the applied loot functions
	 * @return this builder
	 */
	default class_55.class_56 apply(Collection<? extends class_117> functions) {
		throw new UnsupportedOperationException("Implemented via mixin");
	}

	/**
	 * Creates a builder copy of a loot pool.
	 *
	 * @param pool the loot pool
	 * @return the copied builder
	 */
	static class_55.class_56 copyOf(class_55 pool) {
		LootPoolAccessor accessor = (LootPoolAccessor) pool;
		return class_55.method_347()
				.method_352(accessor.fabric_getRolls())
				.method_35509(accessor.fabric_getBonusRolls())
				.method_351(accessor.fabric_getEntries())
				.conditionally(accessor.fabric_getConditions())
				.apply(accessor.fabric_getFunctions());
	}
}
