/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.message.v1;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_7471;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientReceiveMessageEvents {
    public static final Event<AllowChat> ALLOW_CHAT = EventFactory.createArrayBacked(AllowChat.class, listeners -> (message, signedMessage, sender, params, receptionTimestamp) -> {
        boolean allow = true;
        for (AllowChat listener : listeners) {
            allow &= listener.allowReceiveChatMessage(message, signedMessage, sender, params, receptionTimestamp);
        }
        return allow;
    });
    public static final Event<AllowGame> ALLOW_GAME = EventFactory.createArrayBacked(AllowGame.class, listeners -> (message, overlay) -> {
        boolean allow = true;
        for (AllowGame listener : listeners) {
            allow &= listener.allowReceiveGameMessage(message, overlay);
        }
        return allow;
    });
    public static final Event<ModifyGame> MODIFY_GAME = EventFactory.createArrayBacked(ModifyGame.class, listeners -> (message, overlay) -> {
        for (ModifyGame listener : listeners) {
            message = listener.modifyReceivedGameMessage(message, overlay);
        }
        return message;
    });
    public static final Event<Chat> CHAT = EventFactory.createArrayBacked(Chat.class, listeners -> (message, signedMessage, sender, params, receptionTimestamp) -> {
        for (Chat listener : listeners) {
            listener.onReceiveChatMessage(message, signedMessage, sender, params, receptionTimestamp);
        }
    });
    public static final Event<Game> GAME = EventFactory.createArrayBacked(Game.class, listeners -> (message, overlay) -> {
        for (Game listener : listeners) {
            listener.onReceiveGameMessage(message, overlay);
        }
    });
    public static final Event<ChatCanceled> CHAT_CANCELED = EventFactory.createArrayBacked(ChatCanceled.class, listeners -> (message, signedMessage, sender, params, receptionTimestamp) -> {
        for (ChatCanceled listener : listeners) {
            listener.onReceiveChatMessageCanceled(message, signedMessage, sender, params, receptionTimestamp);
        }
    });
    public static final Event<GameCanceled> GAME_CANCELED = EventFactory.createArrayBacked(GameCanceled.class, listeners -> (message, overlay) -> {
        for (GameCanceled listener : listeners) {
            listener.onReceiveGameMessageCanceled(message, overlay);
        }
    });

    private ClientReceiveMessageEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface GameCanceled {
        public void onReceiveGameMessageCanceled(class_2561 var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ChatCanceled {
        public void onReceiveChatMessageCanceled(class_2561 var1, @Nullable class_7471 var2, @Nullable GameProfile var3, class_2556.class_7602 var4, Instant var5);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Game {
        public void onReceiveGameMessage(class_2561 var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Chat {
        public void onReceiveChatMessage(class_2561 var1, @Nullable class_7471 var2, @Nullable GameProfile var3, class_2556.class_7602 var4, Instant var5);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ModifyGame {
        public class_2561 modifyReceivedGameMessage(class_2561 var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AllowGame {
        public boolean allowReceiveGameMessage(class_2561 var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AllowChat {
        public boolean allowReceiveChatMessage(class_2561 var1, @Nullable class_7471 var2, @Nullable GameProfile var3, class_2556.class_7602 var4, Instant var5);
    }
}

