/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.tools;

import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

/**
 * Tool item tags provided by Fabric.
 */
public class FabricToolTags {
	public static final class_3494<class_1792> AXES = register("axes");
	public static final class_3494<class_1792> HOES = register("hoes");
	public static final class_3494<class_1792> PICKAXES = register("pickaxes");
	public static final class_3494<class_1792> SHOVELS = register("shovels");
	public static final class_3494<class_1792> SWORDS = register("swords");

	private FabricToolTags() { }

	private static class_3494<class_1792> register(String id) {
		return TagRegistry.item(new class_2960("fabric", id));
	}
}
