/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.model.loading;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import net.fabricmc.fabric.api.client.model.loading.v1.FabricBakedModelManager;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_793;

@Mixin(class_1092.class)
public class BakedModelManagerMixin implements FabricBakedModelManager {
	@Shadow
	private Map<class_2960, class_1087> models;

	@Override
	public class_1087 getModel(class_2960 id) {
		return models.get(id);
	}

	@Redirect(
			method = "reload",
			at = @At(
					value = "INVOKE",
					target = "java/util/concurrent/CompletableFuture.thenCombineAsync(Ljava/util/concurrent/CompletionStage;Ljava/util/function/BiFunction;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;",
					remap = false
			),
			allow = 1)
	private CompletableFuture<class_1088> loadModelPluginData(
			CompletableFuture<Map<class_2960, class_793>> self,
			CompletionStage<Map<class_2960, List<class_1088.class_7777>>> otherFuture,
			BiFunction<Map<class_2960, class_793>, Map<class_2960, List<class_1088.class_7777>>, class_1088> modelLoaderConstructor,
			Executor executor,
			// reload args
			class_3302.class_4045 synchronizer,
			class_3300 manager,
			class_3695 prepareProfiler,
			class_3695 applyProfiler,
			Executor prepareExecutor,
			Executor applyExecutor) {
		CompletableFuture<List<ModelLoadingPlugin>> pluginsFuture = ModelLoadingPluginManager.preparePlugins(manager, prepareExecutor);
		CompletableFuture<class_3545<Map<class_2960, class_793>, Map<class_2960, List<class_1088.class_7777>>>> pairFuture = self.thenCombine(otherFuture, class_3545::new);
		return pairFuture.thenCombineAsync(pluginsFuture, (pair, plugins) -> {
			ModelLoadingPluginManager.CURRENT_PLUGINS.set(plugins);
			return modelLoaderConstructor.apply(pair.method_15442(), pair.method_15441());
		}, executor);
	}
}
