/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.model.loading;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_324;
import net.minecraft.class_3695;
import net.minecraft.class_793;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1088.class})
public abstract class ModelLoaderMixin
implements ModelLoaderHooks {
    @Final
    @Shadow
    public static class_1091 field_5374;
    @Final
    @Shadow
    private Set<class_2960> field_5390;
    @Final
    @Shadow
    private Map<class_2960, class_1100> field_5376;
    @Shadow
    @Final
    private Map<class_2960, class_1100> field_5394;
    @Unique
    private ModelLoadingEventDispatcher fabric_eventDispatcher;
    private int fabric_guardGetOrLoadModel = 0;
    private boolean fabric_enableGetOrLoadModelGuard = true;

    @Shadow
    private void method_4727(class_1091 id) {
    }

    @Shadow
    public abstract class_1100 method_4726(class_2960 var1);

    @Shadow
    private void method_4715(class_2960 id) {
    }

    @Shadow
    private void method_4729(class_2960 id, class_1100 unbakedModel) {
    }

    @Shadow
    public abstract class_793 method_4718(class_2960 var1);

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="net/minecraft/util/profiler/Profiler.swap(Ljava/lang/String;)V", ordinal=0)})
    private void afterMissingModelInit(class_324 blockColors, class_3695 profiler, Map<class_2960, class_793> jsonUnbakedModels, Map<class_2960, List<class_1088.class_7777>> blockStates, CallbackInfo info) {
        if (!this.field_5376.containsKey(field_5374)) {
            throw new AssertionError((Object)"Missing model not initialized. This is likely a Fabric API porting bug.");
        }
        profiler.method_15405("fabric_plugins_init");
        this.fabric_eventDispatcher = new ModelLoadingEventDispatcher((class_1088)this, ModelLoadingPluginManager.CURRENT_PLUGINS.get());
        ModelLoadingPluginManager.CURRENT_PLUGINS.remove();
        this.fabric_eventDispatcher.addExtraModels(this::addModel);
    }

    @Unique
    private void addModel(class_2960 id) {
        if (id instanceof class_1091) {
            this.method_4727((class_1091)id);
        } else {
            class_1100 unbakedModel = this.method_4726(id);
            this.field_5376.put(id, unbakedModel);
            this.field_5394.put(id, unbakedModel);
        }
    }

    @Inject(method={"getOrLoadModel"}, at={@At(value="HEAD")})
    private void fabric_preventNestedGetOrLoadModel(class_2960 id, CallbackInfoReturnable<class_1100> cir) {
        if (this.fabric_enableGetOrLoadModelGuard && this.fabric_guardGetOrLoadModel > 0) {
            throw new IllegalStateException("ModelLoader#getOrLoadModel called from a ModelResolver or ModelModifier.OnBake instance. This is not allowed to prevent errors during model loading. Use getOrLoadModel from the context instead.");
        }
    }

    @Inject(method={"loadModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLoadModel(class_2960 id, CallbackInfo ci) {
        ++this.fabric_guardGetOrLoadModel;
        try {
            if (this.fabric_eventDispatcher.loadModel(id)) {
                ci.cancel();
            }
        }
        finally {
            --this.fabric_guardGetOrLoadModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ModifyVariable(method={"putModel"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1100 onPutModel(class_1100 model, class_2960 id) {
        ++this.fabric_guardGetOrLoadModel;
        try {
            class_1100 class_11002 = this.fabric_eventDispatcher.modifyModelOnLoad(id, model);
            return class_11002;
        }
        finally {
            --this.fabric_guardGetOrLoadModel;
        }
    }

    @Override
    public ModelLoadingEventDispatcher fabric_getDispatcher() {
        return this.fabric_eventDispatcher;
    }

    @Override
    public class_1100 fabric_getMissingModel() {
        return this.field_5376.get(field_5374);
    }

    @Override
    public class_1100 fabric_getOrLoadModel(class_2960 id) {
        if (this.field_5376.containsKey(id)) {
            return this.field_5376.get(id);
        }
        if (!this.field_5390.add(id)) {
            throw new IllegalStateException("Circular reference while loading " + String.valueOf(id));
        }
        try {
            this.method_4715(id);
        }
        finally {
            this.field_5390.remove(id);
        }
        return this.field_5376.get(id);
    }

    @Override
    public void fabric_putModel(class_2960 id, class_1100 model) {
        this.method_4729(id, model);
    }

    @Override
    public void fabric_putModelDirectly(class_2960 id, class_1100 model) {
        this.field_5376.put(id, model);
    }

    @Override
    public void fabric_queueModelDependencies(class_1100 model) {
        this.field_5390.addAll(model.method_4755());
    }

    @Override
    public class_793 fabric_loadModelFromJson(class_2960 id) {
        return this.method_4718(id);
    }
}

