/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.model.loading.v1;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import org.jetbrains.annotations.Nullable;

/**
 * An unbaked model that returns another {@link class_1087} at {@linkplain #method_4753 bake time}.
 * This allows multiple {@link class_1100}s to share the same {@link class_1087} instance
 * and prevents baking the same model multiple times.
 */
public final class DelegatingUnbakedModel implements class_1100 {
	private final class_2960 delegate;
	private final List<class_2960> dependencies;

	/**
	 * Constructs a new delegating model.
	 *
	 * @param delegate The identifier (can be a {@link class_1091}) of the underlying baked model.
	 */
	public DelegatingUnbakedModel(class_2960 delegate) {
		this.delegate = delegate;
		this.dependencies = List.of(delegate);
	}

	@Override
	public Collection<class_2960> method_4755() {
		return dependencies;
	}

	@Override
	public void method_45785(Function<class_2960, class_1100> modelLoader) {
	}

	@Nullable
	@Override
	public class_1087 method_4753(class_7775 baker, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
		return baker.method_45873(delegate, rotationContainer);
	}
}
