/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.model.loading;

import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_793;

public interface ModelLoaderHooks {
	ModelLoadingEventDispatcher fabric_getDispatcher();

	class_1100 fabric_getMissingModel();

	class_1100 fabric_getOrLoadModel(class_2960 id);

	void fabric_putModel(class_2960 id, class_1100 model);

	void fabric_putModelDirectly(class_2960 id, class_1100 model);

	void fabric_queueModelDependencies(class_1100 model);

	class_793 fabric_loadModelFromJson(class_2960 id);
}
