/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.model.loading;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.FabricBakedModelManager;
import net.fabricmc.fabric.impl.client.model.loading.BakedModelsHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.minecraft.class_10097;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_9824;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1092.class})
abstract class BakedModelManagerMixin
implements FabricBakedModelManager {
    @Shadow
    @Final
    private class_1087 field_5407;
    @Unique
    @Nullable
    private volatile CompletableFuture<ModelLoadingEventDispatcher> eventDispatcherFuture;
    @Unique
    @Nullable
    private Map<class_2960, class_1087> extraModels;

    BakedModelManagerMixin() {
    }

    @Override
    public class_1087 getModel(class_2960 id) {
        if (this.extraModels == null) {
            return this.field_5407;
        }
        return this.extraModels.getOrDefault(id, this.field_5407);
    }

    @Inject(method={"reload"}, at={@At(value="HEAD")})
    private void onHeadReload(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        this.eventDispatcherFuture = ModelLoadingPluginManager.preparePlugins(manager, prepareExecutor).thenApplyAsync(ModelLoadingEventDispatcher::new);
    }

    @ModifyReturnValue(method={"reload"}, at={@At(value="RETURN")})
    private CompletableFuture<Void> resetEventDispatcherFuture(CompletableFuture<Void> future) {
        return future.thenApplyAsync(v -> {
            this.eventDispatcherFuture = null;
            return v;
        });
    }

    @ModifyExpressionValue(method={"reload"}, at={@At(value="INVOKE", target="net/minecraft/client/render/model/BlockStatesLoader.load(Lnet/minecraft/client/render/model/UnbakedModel;Lnet/minecraft/resource/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private CompletableFuture<class_9824.class_10095> hookBlockStateModels(CompletableFuture<class_9824.class_10095> modelsFuture) {
        return modelsFuture.thenCombine(this.eventDispatcherFuture, (models, eventDispatcher) -> eventDispatcher.modifyBlockModelsOnLoad((class_9824.class_10095)models));
    }

    @ModifyArg(method={"reload"}, at=@At(value="INVOKE", target="java/util/concurrent/CompletableFuture.thenApplyAsync(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", ordinal=1), index=0)
    private Function<Void, class_10097> hookModelDiscovery(Function<Void, class_10097> function) {
        return v -> {
            CompletableFuture<ModelLoadingEventDispatcher> future = this.eventDispatcherFuture;
            if (future == null) {
                return (class_10097)function.apply((Void)v);
            }
            ModelLoadingEventDispatcher.CURRENT.set(future.join());
            class_10097 referencedModelsCollector = (class_10097)function.apply((Void)v);
            ModelLoadingEventDispatcher.CURRENT.remove();
            return referencedModelsCollector;
        };
    }

    @ModifyArg(method={"reload"}, at=@At(value="INVOKE", target="java/util/concurrent/CompletableFuture.thenApplyAsync(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", ordinal=3), index=0)
    private Function<Void, Object> hookModelBaking(Function<Void, Object> function) {
        return v -> {
            CompletableFuture<ModelLoadingEventDispatcher> future = this.eventDispatcherFuture;
            if (future == null) {
                return function.apply((Void)v);
            }
            ModelLoadingEventDispatcher.CURRENT.set(future.join());
            Object bakingResult = function.apply((Void)v);
            ModelLoadingEventDispatcher.CURRENT.remove();
            return bakingResult;
        };
    }

    @Inject(method={"upload"}, at={@At(value="INVOKE_STRING", target="net/minecraft/util/profiler/Profiler.swap(Ljava/lang/String;)V", args={"ldc=cache"})})
    private void onUpload(CallbackInfo ci, @Local class_1088.class_10524 bakedModels) {
        this.extraModels = ((BakedModelsHooks)bakedModels).fabric_getExtraModels();
    }
}

