/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.model.loading.v1;

import net.minecraft.class_10419;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_3665;
import net.minecraft.class_7775;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

/**
 * A simple implementation of {@link class_1100} that delegates all method calls to the {@link #wrapped} field.
 * Implementations must set the {@link #wrapped} field somehow.
 */
public abstract class WrapperUnbakedModel implements class_1100 {
	protected class_1100 wrapped;

	protected WrapperUnbakedModel() {
	}

	protected WrapperUnbakedModel(class_1100 wrapped) {
		this.wrapped = wrapped;
	}

	@Override
	public void method_62326(class_10103 resolver) {
		wrapped.method_62326(resolver);
	}

	@Override
	public class_1087 method_4753(class_10419 textures, class_7775 baker, class_3665 settings, boolean ambientOcclusion, boolean isSideLit, class_809 transformation) {
		return wrapped.method_4753(textures, baker, settings, ambientOcclusion, isSideLit, transformation);
	}

	@Override
	@Nullable
	public Boolean method_65537() {
		return wrapped.method_65537();
	}

	@Override
	@Nullable
	public class_4751 method_24298() {
		return wrapped.method_24298();
	}

	@Override
	@Nullable
	public class_809 method_65540() {
		return wrapped.method_65540();
	}

	@Override
	public class_10419.class_10420 method_65539() {
		return wrapped.method_65539();
	}

	@Override
	@Nullable
	public class_1100 method_65538() {
		return wrapped.method_65538();
	}
}
