/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.model.loading;

import java.util.HashMap;
import java.util.Map;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.client.model.loading.BakedModelsHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelBakerHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1088.class_7778;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_7775;
import net.minecraft.class_9979;

@Mixin(class_1088.class)
abstract class ModelBakerMixin implements ModelBakerHooks {
	@Shadow
	@Final
	static Logger LOGGER;

	@Unique
	@Nullable
	private ModelLoadingEventDispatcher fabric_eventDispatcher;

	@Inject(method = "<init>", at = @At("RETURN"))
	private void onReturnInit(CallbackInfo ci) {
		fabric_eventDispatcher = ModelLoadingEventDispatcher.CURRENT.get();
	}

	@WrapOperation(method = "method_65737", at = @At(value = "INVOKE", target = "net/minecraft/client/render/model/GroupableModel.bake(Lnet/minecraft/client/render/model/Baker;)Lnet/minecraft/client/render/model/BakedModel;"))
	private class_1087 wrapBlockModelBake(class_9979 unbakedModel, class_7775 baker, Operation<class_1087> operation, class_1088.class_9826 spriteGetter, Map<class_1091, class_1087> map, class_1091 id) {
		if (fabric_eventDispatcher == null) {
			return operation.call(unbakedModel, baker);
		}

		unbakedModel = fabric_eventDispatcher.modifyBlockModelBeforeBake(unbakedModel, id, baker);
		class_1087 model = operation.call(unbakedModel, baker);
		return fabric_eventDispatcher.modifyBlockModelAfterBake(model, id, unbakedModel, baker);
	}

	@Inject(method = "bake", at = @At("RETURN"))
	private void onReturnBake(class_1088.class_9826 spriteGetter, CallbackInfoReturnable<class_1088.class_10524> cir) {
		if (fabric_eventDispatcher == null) {
			return;
		}

		class_1088.class_10524 models = cir.getReturnValue();
		Map<class_2960, class_1087> extraModels = new HashMap<>();
		fabric_eventDispatcher.forEachExtraModel(id -> {
			try {
				class_1087 model = ((class_1088) (Object) this).new class_7778(spriteGetter, id::toString).method_45873(id, class_1086.field_5350);
				extraModels.put(id, model);
			} catch (Exception e) {
				LOGGER.warn("Unable to bake extra model: '{}': {}", id, e);
			}
		});
		((BakedModelsHooks) (Object) models).fabric_setExtraModels(extraModels);
	}

	@Override
	@Nullable
	public ModelLoadingEventDispatcher fabric_getDispatcher() {
		return fabric_eventDispatcher;
	}
}
