/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginContextImpl;
import net.minecraft.class_10439;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7775;
import net.minecraft.class_9824;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ModelLoadingEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelLoadingEventDispatcher.class);
    public static final ThreadLocal<ModelLoadingEventDispatcher> CURRENT = new ThreadLocal();
    private final ModelLoadingPluginContextImpl pluginContext;
    private final BlockStateResolverContext blockStateResolverContext = new BlockStateResolverContext();
    private final OnLoadModifierContext onLoadModifierContext = new OnLoadModifierContext();
    private final OnLoadBlockModifierContext onLoadBlockModifierContext = new OnLoadBlockModifierContext();

    public ModelLoadingEventDispatcher(List<ModelLoadingPlugin> plugins) {
        this.pluginContext = new ModelLoadingPluginContextImpl();
        for (ModelLoadingPlugin plugin : plugins) {
            try {
                plugin.initialize(this.pluginContext);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to initialize model loading plugin", (Throwable)exception);
            }
        }
    }

    public Map<class_2960, class_1100> modifyModelsOnLoad(Map<class_2960, class_1100> models) {
        if (!(models instanceof HashMap)) {
            models = new HashMap<class_2960, class_1100>(models);
        }
        models.replaceAll(this::modifyModelOnLoad);
        return models;
    }

    private class_1100 modifyModelOnLoad(class_2960 id, class_1100 model) {
        this.onLoadModifierContext.prepare(id);
        return ((ModelModifier.OnLoad)this.pluginContext.modifyModelOnLoad().invoker()).modifyModelOnLoad(model, this.onLoadModifierContext);
    }

    public class_9824.class_10095 modifyBlockModelsOnLoad(class_9824.class_10095 models) {
        HashMap<class_2680, class_1087.class_9979> map = models.comp_3063();
        if (!(map instanceof HashMap)) {
            map = new HashMap<class_2680, class_1087.class_9979>(map);
            models = new class_9824.class_10095(map);
        }
        this.putResolvedBlockStates((Map<class_2680, class_1087.class_9979>)map);
        map.replaceAll(this::modifyBlockModelOnLoad);
        return models;
    }

    private void putResolvedBlockStates(Map<class_2680, class_1087.class_9979> map) {
        this.pluginContext.blockStateResolvers.forEach((block, resolver) -> this.resolveBlockStates((BlockStateResolver)resolver, (class_2248)block, map::put));
    }

    private void resolveBlockStates(BlockStateResolver resolver, class_2248 block, BiConsumer<class_2680, class_1087.class_9979> output) {
        BlockStateResolverContext context = this.blockStateResolverContext;
        context.prepare(block);
        Reference2ReferenceMap<class_2680, class_1087.class_9979> resolvedModels = context.models;
        ImmutableList allStates = block.method_9595().method_11662();
        boolean thrown = false;
        try {
            resolver.resolveBlockStates(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve block state models for block {}. Using missing model for all states.", (Object)block, (Object)e);
            thrown = true;
        }
        if (!thrown) {
            if (resolvedModels.size() == allStates.size()) {
                resolvedModels.forEach(output);
            } else {
                for (class_2680 state : allStates) {
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @Nullable class_1087.class_9979 model = (class_1087.class_9979)resolvedModels.get((Object)state);
                    if (model == null) {
                        LOGGER.error("Block state resolver did not provide a model for state {} in block {}. Using missing model.", (Object)state, (Object)block);
                        continue;
                    }
                    output.accept(state, model);
                }
            }
        }
        resolvedModels.clear();
    }

    private class_1087.class_9979 modifyBlockModelOnLoad(class_2680 state, class_1087.class_9979 model) {
        this.onLoadBlockModifierContext.prepare(state);
        return ((ModelModifier.OnLoadBlock)this.pluginContext.modifyBlockModelOnLoad().invoker()).modifyModelOnLoad(model, this.onLoadBlockModifierContext);
    }

    public class_1087 modifyBlockModel(class_1087.class_9979 unbakedModel, class_2680 state, class_7775 baker, Operation<class_1087> bakeOperation) {
        BakeBlockModifierContext modifierContext = new BakeBlockModifierContext(state, baker);
        unbakedModel = ((ModelModifier.BeforeBakeBlock)this.pluginContext.modifyBlockModelBeforeBake().invoker()).modifyModelBeforeBake(unbakedModel, modifierContext);
        class_1087 model = (class_1087)bakeOperation.call(new Object[]{unbakedModel, state, baker});
        modifierContext.prepareAfterBake(unbakedModel);
        return ((ModelModifier.AfterBakeBlock)this.pluginContext.modifyBlockModelAfterBake().invoker()).modifyModelAfterBake(model, modifierContext);
    }

    public class_10439 modifyItemModel(class_10439.class_10441 unbakedModel, class_2960 itemId, class_10439.class_10440 bakeContext, Operation<class_10439> bakeOperation) {
        BakeItemModifierContext modifierContext = new BakeItemModifierContext(itemId, bakeContext);
        unbakedModel = ((ModelModifier.BeforeBakeItem)this.pluginContext.modifyItemModelBeforeBake().invoker()).modifyModelBeforeBake(unbakedModel, modifierContext);
        class_10439 model = (class_10439)bakeOperation.call(new Object[]{unbakedModel, bakeContext});
        modifierContext.prepareAfterBake(unbakedModel);
        return ((ModelModifier.AfterBakeItem)this.pluginContext.modifyItemModelAfterBake().invoker()).modifyModelAfterBake(model, modifierContext);
    }

    @Environment(value=EnvType.CLIENT)
    private static class BlockStateResolverContext
    implements BlockStateResolver.Context {
        private class_2248 block;
        private final Reference2ReferenceMap<class_2680, class_1087.class_9979> models = new Reference2ReferenceOpenHashMap();

        private BlockStateResolverContext() {
        }

        private void prepare(class_2248 block) {
            this.block = block;
            this.models.clear();
        }

        @Override
        public class_2248 block() {
            return this.block;
        }

        @Override
        public void setModel(class_2680 state, class_1087.class_9979 model) {
            Objects.requireNonNull(state, "state cannot be null");
            Objects.requireNonNull(model, "model cannot be null");
            if (!state.method_27852(this.block)) {
                throw new IllegalArgumentException("Attempted to set model for state " + String.valueOf(state) + " on block " + String.valueOf(this.block));
            }
            if (this.models.putIfAbsent((Object)state, (Object)model) != null) {
                throw new IllegalStateException("Duplicate model for state " + String.valueOf(state) + " on block " + String.valueOf(this.block));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class OnLoadModifierContext
    implements ModelModifier.OnLoad.Context {
        private class_2960 id;

        private OnLoadModifierContext() {
        }

        private void prepare(class_2960 id) {
            this.id = id;
        }

        @Override
        public class_2960 id() {
            return this.id;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class OnLoadBlockModifierContext
    implements ModelModifier.OnLoadBlock.Context {
        private class_2680 state;

        private OnLoadBlockModifierContext() {
        }

        private void prepare(class_2680 state) {
            this.state = state;
        }

        @Override
        public class_2680 state() {
            return this.state;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class BakeBlockModifierContext
    implements ModelModifier.BeforeBakeBlock.Context,
    ModelModifier.AfterBakeBlock.Context {
        private final class_2680 state;
        private final class_7775 baker;
        private class_1087.class_9979 sourceModel;

        private BakeBlockModifierContext(class_2680 state, class_7775 baker) {
            this.state = state;
            this.baker = baker;
        }

        private void prepareAfterBake(class_1087.class_9979 sourceModel) {
            this.sourceModel = sourceModel;
        }

        @Override
        public class_2680 state() {
            return this.state;
        }

        @Override
        public class_7775 baker() {
            return this.baker;
        }

        @Override
        public class_1087.class_9979 sourceModel() {
            return this.sourceModel;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class BakeItemModifierContext
    implements ModelModifier.BeforeBakeItem.Context,
    ModelModifier.AfterBakeItem.Context {
        private final class_2960 itemId;
        private final class_10439.class_10440 bakeContext;
        private class_10439.class_10441 sourceModel;

        private BakeItemModifierContext(class_2960 itemId, class_10439.class_10440 bakeContext) {
            this.itemId = itemId;
            this.bakeContext = bakeContext;
        }

        private void prepareAfterBake(class_10439.class_10441 sourceModel) {
            this.sourceModel = sourceModel;
        }

        @Override
        public class_2960 itemId() {
            return this.itemId;
        }

        @Override
        public class_10439.class_10440 bakeContext() {
            return this.bakeContext;
        }

        @Override
        public class_10439.class_10441 sourceModel() {
            return this.sourceModel;
        }
    }
}

