/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.model.loading;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.UnbakedModelDeserializer;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_793;
import net.minecraft.class_9824;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1092.class})
abstract class BakedModelManagerMixin {
    @Unique
    @Nullable
    private volatile CompletableFuture<ModelLoadingEventDispatcher> eventDispatcherFuture;

    BakedModelManagerMixin() {
    }

    @Inject(method={"method_25931(Lnet/minecraft/class_3302$class_4045;Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")})
    private void onHeadReload(class_3302.class_4045 synchronizer, class_3300 manager, Executor prepareExecutor, Executor applyExecutor, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        this.eventDispatcherFuture = ModelLoadingPluginManager.preparePlugins(manager, prepareExecutor).thenApplyAsync(ModelLoadingEventDispatcher::new);
    }

    @ModifyReturnValue(method={"method_25931(Lnet/minecraft/class_3302$class_4045;Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    private CompletableFuture<Void> resetEventDispatcherFuture(CompletableFuture<Void> future) {
        return future.thenApplyAsync(v -> {
            this.eventDispatcherFuture = null;
            return v;
        });
    }

    @ModifyExpressionValue(method={"method_25931(Lnet/minecraft/class_3302$class_4045;Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1092;method_45881(Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private CompletableFuture<Map<class_2960, class_1100>> hookModels(CompletableFuture<Map<class_2960, class_1100>> modelsFuture) {
        return modelsFuture.thenCombine(this.eventDispatcherFuture, (models, eventDispatcher) -> eventDispatcher.modifyModelsOnLoad((Map<class_2960, class_1100>)models));
    }

    @ModifyExpressionValue(method={"method_25931(Lnet/minecraft/class_3302$class_4045;Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_9824;method_65718(Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private CompletableFuture<class_9824.class_10095> hookBlockStateModels(CompletableFuture<class_9824.class_10095> modelsFuture) {
        return modelsFuture.thenCombine(this.eventDispatcherFuture, (models, eventDispatcher) -> eventDispatcher.modifyBlockModelsOnLoad((class_9824.class_10095)models));
    }

    @ModifyArg(method={"method_25931(Lnet/minecraft/class_3302$class_4045;Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenComposeAsync(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", ordinal=0), index=0)
    private Function<Void, CompletableFuture<?>> hookModelBaking(Function<Void, CompletableFuture<?>> function) {
        return v -> {
            CompletableFuture<ModelLoadingEventDispatcher> future = this.eventDispatcherFuture;
            if (future == null) {
                return (CompletableFuture)function.apply((Void)v);
            }
            ModelLoadingEventDispatcher.CURRENT.set(future.join());
            CompletableFuture bakingResultFuture = (CompletableFuture)function.apply((Void)v);
            ModelLoadingEventDispatcher.CURRENT.remove();
            return bakingResultFuture;
        };
    }

    @Redirect(method={"method_65750(Ljava/util/Map$Entry;)Lcom/mojang/datafixers/util/Pair;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_793;method_3437(Ljava/io/Reader;)Lnet/minecraft/class_793;"))
    private static class_793 cancelVanillaDeserialize(Reader reader) {
        return null;
    }

    @ModifyArg(method={"method_65750(Ljava/util/Map$Entry;)Lcom/mojang/datafixers/util/Pair;"}, at=@At(value="INVOKE", target="Lcom/mojang/datafixers/util/Pair;of(Ljava/lang/Object;Ljava/lang/Object;)Lcom/mojang/datafixers/util/Pair;", remap=false), index=1)
    private static Object actuallyDeserializeModel(Object originalModel, @Local Reader reader) {
        return UnbakedModelDeserializer.deserialize(reader);
    }
}

