/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.CompositeBlockStateModel;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10526;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CompositeBlockStateModelImpl
implements CompositeBlockStateModel {
    private final class_1087[] models;
    private final @UnmodifiableView List<class_1087> modelsView;

    public CompositeBlockStateModelImpl(class_1087[] models) {
        this.models = models;
        this.modelsView = Arrays.asList(models);
    }

    public static CompositeBlockStateModelImpl of(List<class_1087> models) {
        if (models.isEmpty()) {
            throw new IllegalArgumentException("Models list must not be empty");
        }
        for (class_1087 model : models) {
            Objects.requireNonNull(model, "Model cannot be null");
        }
        return new CompositeBlockStateModelImpl((class_1087[])models.toArray(class_1087[]::new));
    }

    @Override
    public @Unmodifiable List<class_1087> models() {
        return this.modelsView;
    }

    public void method_68513(class_5819 random, List<class_10889> parts) {
        long seed = random.method_43055();
        for (class_1087 model : this.models) {
            random.method_43052(seed);
            model.method_68513(random, parts);
        }
    }

    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
        long seed = random.method_43055();
        for (class_1087 model : this.models) {
            random.method_43052(seed);
            model.emitQuads(emitter, blockView, pos, state, random, cullTest);
        }
    }

    public @Nullable Object createGeometryKey(class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random) {
        int count = this.models.length;
        long seed = random.method_43055();
        if (count == 1) {
            random.method_43052(seed);
            return this.models[0].createGeometryKey(blockView, pos, state, random);
        }
        ArrayList<Object> subkeys = new ArrayList<Object>(count);
        for (class_1087 submodel : this.models) {
            random.method_43052(seed);
            Object subkey = submodel.createGeometryKey(blockView, pos, state, random);
            if (subkey == null) {
                return null;
            }
            subkeys.add(subkey);
        }
        @Environment(value=EnvType.CLIENT)
        record Key(List<Object> subkeys) {
        }
        return new Key(subkeys);
    }

    public class_1058 method_68511() {
        return this.models[0].method_68511();
    }

    public class_1058 particleSprite(class_1920 blockView, class_2338 pos, class_2680 state) {
        return this.models[0].particleSprite(blockView, pos, state);
    }

    @Environment(value=EnvType.CLIENT)
    public record Unbaked(@Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    class_1087.class_10892> models) implements CompositeBlockStateModel.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.method_36973((Codec)class_1087.class_10892.field_57944.listOf()).fieldOf("models").forGetter(Unbaked::models)).apply((Applicative)instance, Unbaked::new));

        public static Unbaked of(List<class_1087.class_10892> models) {
            if (models.isEmpty()) {
                throw new IllegalArgumentException("Models list must not be empty");
            }
            for (class_1087.class_10892 model : models) {
                Objects.requireNonNull(model, "Model cannot be null");
            }
            return new Unbaked(List.copyOf(models));
        }

        public MapCodec<Unbaked> codec() {
            return CODEC;
        }

        public class_1087 method_68521(class_7775 baker) {
            class_1087[] bakedModels = new class_1087[this.models.size()];
            for (int i = 0; i < this.models.size(); ++i) {
                bakedModels[i] = this.models.get(i).method_68521(baker);
            }
            return new CompositeBlockStateModelImpl(bakedModels);
        }

        public void method_62326(class_10526.class_10103 resolver) {
            this.models.forEach(model -> model.method_62326(resolver));
        }
    }
}

