/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.model.loading.v1;

import net.minecraft.class_10439;
import net.minecraft.class_10526;
import net.minecraft.class_7775;

/**
 * An unbaked extra model.
 *
 * <p>Similar to {@link class_10439.class_10441} and other {@link class_10526}, this model can
 * {@linkplain class_10526.class_10103#method_62326(class_10103) depend} on one or more model files, and then combine them into
 * a single baked model.
 *
 * @param <T> The type of the baked model.
 * @see ModelLoadingPlugin.Context#addModel(ExtraModelKey, UnbakedExtraModel)
 */
public interface UnbakedExtraModel<T> extends class_10526 {
	/**
	 * Bake this model.
	 *
	 * @param baker The current model baker.
	 * @return The fully-baked model.
	 */
	T bake(class_7775 baker);
}
