/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.model.loading.v1.wrapper;

import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11566;
import net.minecraft.class_1799;
import net.minecraft.class_638;
import net.minecraft.class_811;
import org.jspecify.annotations.Nullable;

/**
 * A simple implementation of {@link class_10439} that delegates all method calls to the {@link #wrapped} field.
 * Implementations must set the {@link #wrapped} field somehow.
 */
public abstract class WrapperBakedItemModel implements class_10439 {
	protected class_10439 wrapped;

	protected WrapperBakedItemModel() {
	}

	protected WrapperBakedItemModel(class_10439 wrapped) {
		this.wrapped = wrapped;
	}

	@Override
	public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 heldItemContext, int seed) {
		wrapped.method_65584(state, stack, resolver, displayContext, world, heldItemContext, seed);
	}
}
