/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.CustomPayloadC2SPacketAccessor;
import net.fabricmc.fabric.mixin.networking.accessor.ServerPlayNetworkHandlerAccessor;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class ServerPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ServerPlayNetworking.PlayChannelHandler> {
    private final class_3244 handler;
    private final MinecraftServer server;
    private boolean sentInitialRegisterPacket;

    public ServerPlayNetworkAddon(class_3244 handler, MinecraftServer server) {
        super(ServerNetworkingImpl.PLAY, ((ServerPlayNetworkHandlerAccessor)handler).getConnection(), "ServerPlayNetworkAddon for " + handler.field_14140.method_5820());
        this.handler = handler;
        this.server = server;
        this.registerPendingChannels((ChannelInfoHolder)this.connection);
        this.receiver.startSession(this);
    }

    @Override
    public void lateInit() {
        for (Map.Entry entry : this.receiver.getHandlers().entrySet()) {
            this.registerChannel(entry.getKey(), (ServerPlayNetworking.PlayChannelHandler)entry.getValue());
        }
        ((ServerPlayConnectionEvents.Init)ServerPlayConnectionEvents.INIT.invoker()).onPlayInit(this.handler, this.server);
    }

    public void onClientReady() {
        ((ServerPlayConnectionEvents.Join)ServerPlayConnectionEvents.JOIN.invoker()).onPlayReady(this.handler, this, this.server);
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    public boolean handle(class_2817 packet) {
        CustomPayloadC2SPacketAccessor access = (CustomPayloadC2SPacketAccessor)packet;
        return this.handle(access.getChannel(), access.getData());
    }

    @Override
    protected void receive(ServerPlayNetworking.PlayChannelHandler handler, class_2540 buf) {
        handler.receive(this.server, this.handler.field_14140, this.handler, buf, this);
    }

    @Override
    protected void schedule(Runnable task) {
        this.handler.field_14140.field_13995.execute(task);
    }

    @Override
    public class_2596<?> createPacket(class_2960 channelName, class_2540 buf) {
        return ServerPlayNetworking.createS2CPacket(channelName, buf);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((S2CPlayChannelEvents.Register)S2CPlayChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.server, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((S2CPlayChannelEvents.Unregister)S2CPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.server, ids);
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
        class_2540 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
        class_2540 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerPlayConnectionEvents.Disconnect)ServerPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect(this.handler, this.server);
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return NetworkingImpl.isReservedPlayChannel(channelName);
    }
}

