/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.networking;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public record CommonRegisterPayload(int version, String phase, Set<class_2960> channels) implements class_8710 {
	public static final class_8710.class_9154<CommonRegisterPayload> ID = new class_9154<>(class_2960.method_60654("c:register"));
	public static final class_9139<class_2540, CommonRegisterPayload> CODEC = class_8710.method_56484(CommonRegisterPayload::write, CommonRegisterPayload::new);

	public static final String PLAY_PHASE = "play";
	public static final String CONFIGURATION_PHASE = "configuration";

	private CommonRegisterPayload(class_2540 buf) {
		this(
				buf.method_10816(),
				buf.method_19772(),
				buf.method_34068(HashSet::new, class_2540::method_10810)
		);
	}

	public void write(class_2540 buf) {
		buf.method_10804(version);
		buf.method_10814(phase);
		buf.method_34062(channels, class_2540::method_10812);
	}

	@Override
	public class_9154<CommonRegisterPayload> method_56479() {
		return ID;
	}
}
