/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.networking.client;

import java.util.Collections;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.GlobalReceiverRegistry;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8673;

abstract class ClientCommonNetworkAddon<H, T extends class_8673> extends AbstractChanneledNetworkAddon<H> {
	protected final T handler;
	protected final class_310 client;

	protected boolean isServerReady = false;

	protected ClientCommonNetworkAddon(GlobalReceiverRegistry<H> receiver, class_2535 connection, String description, T handler, class_310 client) {
		super(receiver, connection, description);
		this.handler = handler;
		this.client = client;
	}

	public void onServerReady() {
		this.isServerReady = true;
	}

	@Override
	protected void handleRegistration(class_2960 channelName) {
		// If we can already send packets, immediately send the register packet for this channel
		if (this.isServerReady) {
			final RegistrationPayload payload = this.createRegistrationPayload(RegistrationPayload.REGISTER, Collections.singleton(channelName));

			if (payload != null) {
				this.sendPacket(payload);
			}
		}
	}

	@Override
	protected void handleUnregistration(class_2960 channelName) {
		// If we can already send packets, immediately send the unregister packet for this channel
		if (this.isServerReady) {
			final RegistrationPayload payload = this.createRegistrationPayload(RegistrationPayload.UNREGISTER, Collections.singleton(channelName));

			if (payload != null) {
				this.sendPacket(payload);
			}
		}
	}

	@Override
	protected boolean isReservedChannel(class_2960 channelName) {
		return NetworkingImpl.isReservedCommonChannel(channelName);
	}

	@Override
	protected void schedule(Runnable task) {
		client.execute(task);
	}
}
