/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import java.util.Collections;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.GlobalReceiverRegistry;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8673;

@Environment(value=EnvType.CLIENT)
abstract class ClientCommonNetworkAddon<H, T extends class_8673>
extends AbstractChanneledNetworkAddon<H> {
    protected final T handler;
    protected final class_310 client;
    protected boolean isServerReady = false;

    protected ClientCommonNetworkAddon(GlobalReceiverRegistry<H> receiver, class_2535 connection, String description, T handler, class_310 client) {
        super(receiver, connection, description);
        this.handler = handler;
        this.client = client;
    }

    public void onServerReady() {
        this.isServerReady = true;
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
        RegistrationPayload payload;
        if (this.isServerReady && (payload = this.createRegistrationPayload(RegistrationPayload.REGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(payload);
        }
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
        RegistrationPayload payload;
        if (this.isServerReady && (payload = this.createRegistrationPayload(RegistrationPayload.UNREGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(payload);
        }
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return NetworkingImpl.isReservedCommonChannel(channelName);
    }

    @Override
    protected void schedule(Runnable task) {
        this.client.execute(task);
    }
}

