/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import net.minecraft.class_10961;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2817;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.class_8792;
import net.minecraft.class_9127;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.UntrackedNetworkHandler;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.impl.networking.server.ServerPlayNetworkAddon;

// We want to apply a bit earlier than other mods which may not use us in order to prevent refCount issues
@Mixin(value = class_3244.class, priority = 999)
abstract class ServerPlayNetworkHandlerMixin extends class_8609 implements NetworkHandlerExtensions {
	@Unique
	private ServerPlayNetworkAddon addon;

	ServerPlayNetworkHandlerMixin(class_10961 server, class_2535 connection, class_8792 arg) {
		super(server, connection, arg);
	}

	@Inject(method = "<init>", at = @At("RETURN"))
	private void initAddon(class_10961 gameInstance, class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
		this.addon = new ServerPlayNetworkAddon((class_3244) (Object) this, connection, gameInstance.method_68961());

		if (!(this instanceof UntrackedNetworkHandler)) {
			// A bit of a hack but it allows the field above to be set in case someone registers handlers during INIT event which refers to said field
			this.addon.lateInit();
		}
	}

	@Inject(method = "onCustomPayload", at = @At("HEAD"), cancellable = true)
	private void handleCustomPayloadReceivedAsync(class_2817 packet, CallbackInfo ci) {
		if (getAddon().handle(packet.comp_1647())) {
			ci.cancel();
		}
	}

	@WrapOperation(method = "onAcknowledgeReconfiguration", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/ClientConnection;transitionInbound(Lnet/minecraft/network/state/NetworkState;Lnet/minecraft/network/listener/PacketListener;)V"))
	private <T extends class_2547> void onAcknowledgeReconfiguration(class_2535 instance, class_9127<T> state, T packetListener, Operation<Void> original) {
		original.call(instance, state, packetListener);

		class_8610 networkHandler = (class_8610) packetListener;
		ServerNetworkingImpl.getAddon(networkHandler).setReconfiguring();

		if (addon.requestedReconfigure()) {
			networkHandler.method_52409();
		}
	}

	@Override
	public ServerPlayNetworkAddon getAddon() {
		return this.addon;
	}
}
