/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.client.ClientConfigurationNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8674;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientConfigurationNetworking {
    public static <T extends class_8710> boolean registerGlobalReceiver(class_8710.class_9154<T> type, ConfigurationPayloadHandler<T> handler) {
        return ClientNetworkingImpl.CONFIGURATION.registerGlobalReceiver(type.comp_2242(), handler);
    }

    @Nullable
    public static ConfigurationPayloadHandler<?> unregisterGlobalReceiver(class_8710.class_9154<?> id) {
        return ClientNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(id.comp_2242());
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ClientNetworkingImpl.CONFIGURATION.getChannels();
    }

    public static <T extends class_8710> boolean registerReceiver(class_8710.class_9154<T> id, ConfigurationPayloadHandler<T> handler) {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.registerChannel(id.comp_2242(), handler);
        }
        throw new IllegalStateException("Cannot register receiver while not configuring!");
    }

    @Nullable
    public static ConfigurationPayloadHandler<?> unregisterReceiver(class_2960 id) {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return (ConfigurationPayloadHandler)addon.unregisterChannel(id);
        }
        throw new IllegalStateException("Cannot unregister receiver while not configuring!");
    }

    public static Set<class_2960> getReceived() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not configuring!");
    }

    public static Set<class_2960> getSendable() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not configuring!");
    }

    public static boolean canSend(class_2960 channelName) throws IllegalArgumentException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon.getSendableChannels().contains(channelName);
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not configuring!");
    }

    public static boolean canSend(class_8710.class_9154<?> type) {
        return ClientConfigurationNetworking.canSend(type.comp_2242());
    }

    public static PacketSender getSender() throws IllegalStateException {
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            return addon;
        }
        throw new IllegalStateException("Cannot get PacketSender while not configuring!");
    }

    public static void send(class_8710 payload) {
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.method_56479(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        ClientConfigurationNetworkAddon addon = ClientNetworkingImpl.getClientConfigurationAddon();
        if (addon != null) {
            addon.sendPacket(payload);
            return;
        }
        throw new IllegalStateException("Cannot send packet while not configuring!");
    }

    private ClientConfigurationNetworking() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ConfigurationPayloadHandler<T extends class_8710> {
        public void receive(T var1, Context var2);
    }

    @Environment(value=EnvType.CLIENT)
    @ApiStatus.NonExtendable
    public static interface Context {
        public class_310 client();

        public class_8674 networkHandler();

        public PacketSender responseSender();
    }
}

