/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8705;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayNetworking {
    public static <T extends class_8710> boolean registerGlobalReceiver(class_8710.class_9154<T> type, PlayPayloadHandler<T> handler) {
        return ServerNetworkingImpl.PLAY.registerGlobalReceiver(type.comp_2242(), handler);
    }

    @Nullable
    public static PlayPayloadHandler<?> unregisterGlobalReceiver(class_2960 id) {
        return ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(id);
    }

    public static Set<class_2960> getGlobalReceivers() {
        return ServerNetworkingImpl.PLAY.getChannels();
    }

    public static <T extends class_8710> boolean registerReceiver(class_3244 networkHandler, class_8710.class_9154<T> type, PlayPayloadHandler<T> handler) {
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(type.comp_2242(), handler);
    }

    @Nullable
    public static PlayPayloadHandler<?> unregisterReceiver(class_3244 networkHandler, class_2960 id) {
        return (PlayPayloadHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(id);
    }

    public static Set<class_2960> getReceived(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getReceived(player.field_13987);
    }

    public static Set<class_2960> getReceived(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<class_2960> getSendable(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSendable(player.field_13987);
    }

    public static Set<class_2960> getSendable(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(class_3222 player, class_2960 channelName) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.field_13987, channelName);
    }

    public static boolean canSend(class_3222 player, class_8710.class_9154<?> type) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.field_13987, type.comp_2242());
    }

    public static boolean canSend(class_3244 handler, class_2960 channelName) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static boolean canSend(class_3244 handler, class_8710.class_9154<?> type) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(type, "Packet type cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(type.comp_2242());
    }

    public static <T extends class_8710> class_2596<class_8705> createS2CPacket(T packet) {
        return ServerNetworkingImpl.createS2CPacket(packet);
    }

    public static PacketSender getSender(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSender(player.field_13987);
    }

    public static PacketSender getSender(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(class_3222 player, class_8710 payload) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.method_56479(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        player.field_13987.method_14364(ServerPlayNetworking.createS2CPacket(payload));
    }

    public static void reconfigure(class_3222 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        ServerPlayNetworking.reconfigure(player.field_13987);
    }

    public static void reconfigure(class_3244 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        ServerNetworkingImpl.getAddon(handler).reconfigure();
    }

    private ServerPlayNetworking() {
    }

    @FunctionalInterface
    public static interface PlayPayloadHandler<T extends class_8710> {
        public void receive(T var1, Context var2);
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public MinecraftServer server();

        public class_3222 player();

        public PacketSender responseSender();
    }
}

