/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2596;
import net.minecraft.class_8038;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_8038.class)
public class BundlePacketMixin {
	@ModifyVariable(method = "<init>", at = @At("HEAD"), argsOnly = true)
	private static Iterable<? extends class_2596<?>> flattenBundlePackets(Iterable<? extends class_2596<?>> value) {
		var packets = new ArrayList<class_2596<?>>();
		iterateBundle(value, packets);
		return packets;
	}

	@Unique
	private static void iterateBundle(Iterable<? extends class_2596<?>> value, List<class_2596<?>> result) {
		for (class_2596<?> packet : value) {
			if (packet instanceof class_8038<?> bundlePacket) {
				iterateBundle(bundlePacket.method_48324(), result);
			} else {
				result.add(packet);
			}
		}
	}
}
