/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.networking;

import java.util.ArrayList;
import net.minecraft.class_2598;
import net.minecraft.class_9095;
import net.minecraft.class_9127;
import net.minecraft.class_9145;
import net.minecraft.class_9157;
import org.jspecify.annotations.Nullable;

public record VanillaPacketTypes(class_9145<?>[] ids) {
	public static final VanillaPacketTypes PLAY_S2C = of(class_9095.field_48173);
	public static final VanillaPacketTypes PLAY_C2S = of(class_9095.field_48172);
	public static final VanillaPacketTypes CONFIGURATION_S2C = of(class_9157.field_52195);
	public static final VanillaPacketTypes CONFIGURATION_C2S = of(class_9157.field_52194);

	@Nullable
	public class_9145<?> get(int id) {
		return id > 0 && id < this.ids.length ? this.ids[id] : null;
	}

	private static VanillaPacketTypes of(class_9127.class_10940 factory) {
		var list = new ArrayList<class_9145<?>>();

		// See NetworkStateBuilder#createState for reference.
		factory.method_68854().method_61108((type, i) -> list.add(type));

		return new VanillaPacketTypes(list.toArray(class_9145[]::new));
	}

	public static VanillaPacketTypes get(class_9127<?> state) {
		return switch (state.comp_2234()) {
		case field_45671 -> state.comp_2235() == class_2598.field_11942 ? CONFIGURATION_S2C : CONFIGURATION_C2S;
		case field_20591 -> state.comp_2235() == class_2598.field_11942 ? PLAY_S2C : PLAY_C2S;
		default -> throw new IllegalArgumentException("Not implemented for " + state.comp_2234() + "!");
		};
	}
}
