/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonPacketListenerImplAccessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public final class ServerConfigurationNetworking {
    public static <T extends CustomPacketPayload> boolean registerGlobalReceiver(CustomPacketPayload.Type<T> type, ConfigurationPacketHandler<T> handler) {
        return ServerNetworkingImpl.CONFIGURATION.registerGlobalReceiver(type.id(), handler);
    }

    public static @Nullable ConfigurationPacketHandler<?> unregisterGlobalReceiver(Identifier id) {
        return ServerNetworkingImpl.CONFIGURATION.unregisterGlobalReceiver(id);
    }

    public static Set<Identifier> getGlobalReceivers() {
        return ServerNetworkingImpl.CONFIGURATION.getChannels();
    }

    public static <T extends CustomPacketPayload> boolean registerReceiver(ServerConfigurationPacketListenerImpl networkHandler, CustomPacketPayload.Type<T> type, ConfigurationPacketHandler<T> handler) {
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(type.id(), handler);
    }

    public static @Nullable ConfigurationPacketHandler<?> unregisterReceiver(ServerConfigurationPacketListenerImpl networkHandler, Identifier id) {
        return (ConfigurationPacketHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(id);
    }

    public static Set<Identifier> getReceived(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<Identifier> getSendable(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(ServerConfigurationPacketListenerImpl handler, Identifier channelName) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static boolean canSend(ServerConfigurationPacketListenerImpl handler, CustomPacketPayload.Type<?> id) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        Objects.requireNonNull(id, "Payload id cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(id.id());
    }

    public static Packet<ClientCommonPacketListener> createS2CPacket(CustomPacketPayload payload) {
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.type(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        return ServerNetworkingImpl.createS2CPacket(payload);
    }

    public static PacketSender getSender(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(ServerConfigurationPacketListenerImpl handler, CustomPacketPayload payload) {
        Objects.requireNonNull(handler, "Server configuration handler cannot be null");
        Objects.requireNonNull(payload, "Payload cannot be null");
        Objects.requireNonNull(payload.type(), "CustomPayload#getId() cannot return null for payload class: " + String.valueOf(payload.getClass()));
        handler.send(ServerConfigurationNetworking.createS2CPacket(payload));
    }

    public static MinecraftServer getServer(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return ((ServerCommonPacketListenerImplAccessor)handler).getServer();
    }

    public static boolean isReconfiguring(ServerConfigurationPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server configuration network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).isReconfiguring();
    }

    private ServerConfigurationNetworking() {
    }

    @FunctionalInterface
    public static interface ConfigurationPacketHandler<T extends CustomPacketPayload> {
        public void receive(T var1, Context var2);
    }

    @ApiStatus.NonExtendable
    public static interface Context {
        public MinecraftServer server();

        public ServerConfigurationPacketListenerImpl networkHandler();

        public PacketSender responseSender();
    }
}

