/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networkingblockentity;

import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2586.class)
public abstract class MixinBlockEntity {
	@Shadow
	public abstract class_2591<?> getType();

	@Shadow
	public abstract class_2338 getPos();

	@Inject(at = @At("HEAD"), method = "toUpdatePacket", cancellable = true)
	public void toUpdatePacket(CallbackInfoReturnable<class_2622> info) {
		Object self = (Object) this;

		if (self instanceof BlockEntityClientSerializable) {
			// Mojang's serialization of x/y/z into the update packet is redundant,
			// as we have a separate fromClientTag() we don't do it.
			// However, we use the "id" field for type discernment, as actionId
			// is capped at 8 bits of size with the values presumably reserved
			// by Mojang.

			class_2487 tag = new class_2487();
			class_2960 entityId = class_2591.method_11033(getType());
			if (entityId == null) {
				throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
			}

			tag.method_10582("id", entityId.toString());
			tag = ((BlockEntityClientSerializable) self).toClientTag(tag);
			info.setReturnValue(new class_2622(getPos(), 127, tag));
			info.cancel();
		}
	}

	@Inject(at = @At("RETURN"), method = "toInitialChunkDataTag", cancellable = true)
	public void toInitialChunkDataTag(CallbackInfoReturnable<class_2487> info) {
		Object self = (Object) this;

		if (self instanceof BlockEntityClientSerializable && info.getReturnValue() != null) {
			info.setReturnValue(((BlockEntityClientSerializable) self).toClientTag(info.getReturnValue()));
		}
	}
}
