/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.network;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import net.fabricmc.fabric.api.event.network.S2CPacketTypeCallback;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketContext;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ClientSidePacketRegistryImpl extends PacketRegistryImpl implements ClientSidePacketRegistry {
	private final Collection<class_2960> serverPayloadIds = new HashSet<>();

	public static void invalidateRegisteredIdList() {
		((ClientSidePacketRegistryImpl) ClientSidePacketRegistry.INSTANCE).serverPayloadIds.clear();
	}

	@Override
	public boolean canServerReceive(class_2960 id) {
		return serverPayloadIds.contains(id);
	}

	@Override
	public void sendToServer(class_2596<?> packet, GenericFutureListener<? extends Future<? super Void>> completionListener) {
		class_634 handler = class_310.method_1551().method_1562();
		if (handler != null) {
			if (completionListener == null) {
				// stay closer to the vanilla codepath
				handler.method_2883(packet);
			} else {
				handler.method_2872().method_10752(packet, completionListener);
			}
		} else {
			LOGGER.warn("Sending packet " + packet + " to server failed, not connected!");
		}
	}

	@Override
	public class_2596<?> toPacket(class_2960 id, class_2540 buf) {
		return new class_2817(id, buf);
	}

	@Override
	protected void onRegister(class_2960 id) {
		class_634 handler = class_310.method_1551().method_1562();
		if (handler != null) {
			createRegisterTypePacket(PacketTypes.REGISTER, Collections.singleton(id)).ifPresent(handler::method_2883);
		}
	}

	@Override
	protected void onUnregister(class_2960 id) {
		class_634 handler = class_310.method_1551().method_1562();
		if (handler != null) {
			createRegisterTypePacket(PacketTypes.UNREGISTER, Collections.singleton(id)).ifPresent(handler::method_2883);
		}
	}

	@Override
	protected Collection<class_2960> getIdCollectionFor(PacketContext context) {
		return serverPayloadIds;
	}

	@Override
	protected void onReceivedRegisterPacket(PacketContext context, Collection<class_2960> ids) {
		S2CPacketTypeCallback.REGISTERED.invoker().accept(ids);
	}

	@Override
	protected void onReceivedUnregisterPacket(PacketContext context, Collection<class_2960> ids) {
		S2CPacketTypeCallback.UNREGISTERED.invoker().accept(ids);
	}

	public final boolean accept(class_2658 packet, PacketContext context) {
		return accept(packet.method_11456(), context, packet.method_11458());
	}
}
