/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.impl.network.ClientSidePacketRegistryImpl;
import net.fabricmc.fabric.impl.network.PacketDebugOptions;
import net.fabricmc.fabric.impl.network.PacketRegistryImpl;
import net.fabricmc.fabric.impl.network.PacketTypes;
import net.minecraft.class_1255;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2678;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Optional;

@Mixin(class_634.class)
public abstract class MixinClientPlayNetworkHandler implements PacketContext {
	@Shadow
	private class_310 client;

	@Shadow
	public abstract void sendPacket(class_2596<?> var1);

	@Inject(at = @At("RETURN"), method = "onGameJoin")
	public void onGameJoin(class_2678 packet, CallbackInfo info) {
		Optional<class_2596<?>> optionalPacket = PacketRegistryImpl.createInitialRegisterPacket(ClientSidePacketRegistry.INSTANCE);
		//noinspection OptionalIsPresent
		if (optionalPacket.isPresent()) {
			sendPacket(optionalPacket.get());
		}
	}

	// Optional hook: it only removes a warning message.
	@Inject(method = "onCustomPayload", at = @At(value = "CONSTANT", args = "stringValue=Unknown custom packed identifier: {}"), cancellable = true, locals = LocalCapture.CAPTURE_FAILSOFT, require = 0)
	public void onCustomPayloadNotFound(class_2658 packet, CallbackInfo info, class_2960 id, class_2540 buf) {
		if (packet.method_11456().equals(PacketTypes.REGISTER) || packet.method_11456().equals(PacketTypes.UNREGISTER)) {
			if (buf.refCnt() > 0) {
				buf.release();
			}

			info.cancel();
		}
	}

	@Inject(method = "onCustomPayload", at = @At("HEAD"), cancellable = true)
	public void onCustomPayload(class_2658 packet, CallbackInfo info) {
		if (((ClientSidePacketRegistryImpl) ClientSidePacketRegistry.INSTANCE).accept(packet.method_11456(), this, packet::method_11458)) {
			info.cancel();
		}
	}

	@Override
	public EnvType getPacketEnvironment() {
		return EnvType.CLIENT;
	}

	@Override
	public class_1657 getPlayer() {
		return client.field_1724;
	}

	@Override
	public class_1255 getTaskQueue() {
		return client;
	}
}
