/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.network;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import net.fabricmc.fabric.api.event.network.C2SPacketTypeCallback;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2913;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import java.lang.ref.WeakReference;
import java.util.*;
import java.util.function.Consumer;

public class ServerSidePacketRegistryImpl extends PacketRegistryImpl implements ServerSidePacketRegistry {
	private final WeakHashMap<class_1657, Collection<class_2960>> playerPayloadIds = new WeakHashMap<>();
	private final Set<WeakReference<class_3244>> handlers = new HashSet<>();

	public void onQueryResponse(class_2913 packet) {
	}

	public void addNetworkHandler(class_3244 handler) {
		handlers.add(new WeakReference<>(handler));
	}

	protected void forEachHandler(Consumer<class_3244> consumer) {
		Iterator<WeakReference<class_3244>> it = handlers.iterator();
		while (it.hasNext()) {
			class_3244 server = it.next().get();
			if (server != null) {
				consumer.accept(server);
			} else {
				it.remove();
			}
		}
	}

	@Override
	public boolean canPlayerReceive(class_1657 player, class_2960 id) {
		Collection<class_2960> ids = playerPayloadIds.get(player);
		if (ids != null) {
			return ids.contains(id);
		} else {
			return false;
		}
	}

	@Override
	public void sendToPlayer(class_1657 player, class_2596<?> packet, GenericFutureListener<? extends Future<? super Void>> completionListener) {
		if (!(player instanceof class_3222)) {
			throw new RuntimeException("Can only send to ServerPlayerEntities!");
		} else {
			((class_3222) player).field_13987.method_14369(packet, completionListener);
		}
	}

	@Override
	public class_2596<?> toPacket(class_2960 id, class_2540 buf) {
		return new class_2658(id, buf);
	}

	@Override
	protected void onRegister(class_2960 id) {
		createRegisterTypePacket(PacketTypes.REGISTER, Collections.singleton(id))
			.ifPresent((packet) -> forEachHandler((n) -> n.method_14364(packet)));
	}

	@Override
	protected void onUnregister(class_2960 id) {
		createRegisterTypePacket(PacketTypes.UNREGISTER, Collections.singleton(id))
			.ifPresent((packet) -> forEachHandler((n) -> n.method_14364(packet)));
	}

	@Override
	protected Collection<class_2960> getIdCollectionFor(PacketContext context) {
		return playerPayloadIds.computeIfAbsent(context.getPlayer(), (p) -> new HashSet<>());
	}

	@Override
	protected void onReceivedRegisterPacket(PacketContext context, Collection<class_2960> ids) {
		C2SPacketTypeCallback.REGISTERED.invoker().accept(context.getPlayer(), ids);
	}

	@Override
	protected void onReceivedUnregisterPacket(PacketContext context, Collection<class_2960> ids) {
		C2SPacketTypeCallback.UNREGISTERED.invoker().accept(context.getPlayer(), ids);
	}
}
