/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.network;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.impl.network.CustomPayloadC2SPacketAccessor;
import net.minecraft.class_2540;
import net.minecraft.class_2817;
import net.minecraft.class_2960;

@Mixin(class_2817.class)
public class MixinCustomPayloadC2SPacket implements CustomPayloadC2SPacketAccessor {
	@Shadow
	private class_2960 channel;
	@Shadow
	private class_2540 data;

	@Override
	public class_2960 getChannel() {
		return channel;
	}

	@Override
	public class_2540 getData() {
		return new class_2540(this.data.copy());
	}
}
