/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.network;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.PacketRegistry;
import net.fabricmc.fabric.impl.network.PacketTypes;
import net.minecraft.class_151;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PacketRegistryImpl
implements PacketRegistry {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Map<class_2960, PacketConsumer> consumerMap = new LinkedHashMap<class_2960, PacketConsumer>();

    PacketRegistryImpl() {
    }

    public static Optional<class_2596<?>> createInitialRegisterPacket(PacketRegistry registry) {
        PacketRegistryImpl impl = (PacketRegistryImpl)registry;
        return impl.createRegisterTypePacket(PacketTypes.REGISTER, impl.consumerMap.keySet());
    }

    @Override
    public void register(class_2960 id, PacketConsumer consumer) {
        boolean isNew = true;
        if (this.consumerMap.containsKey(id)) {
            LOGGER.warn("Registered duplicate packet " + id + "!");
            LOGGER.trace((Object)new Throwable());
            isNew = false;
        }
        this.consumerMap.put(id, consumer);
        if (isNew) {
            this.onRegister(id);
        }
    }

    @Override
    public void unregister(class_2960 id) {
        if (this.consumerMap.remove(id) != null) {
            this.onUnregister(id);
        } else {
            LOGGER.warn("Tried to unregister non-registered packet " + id + "!");
            LOGGER.trace((Object)new Throwable());
        }
    }

    protected abstract void onRegister(class_2960 var1);

    protected abstract void onUnregister(class_2960 var1);

    protected abstract Collection<class_2960> getIdCollectionFor(PacketContext var1);

    protected abstract void onReceivedRegisterPacket(PacketContext var1, Collection<class_2960> var2);

    protected abstract void onReceivedUnregisterPacket(PacketContext var1, Collection<class_2960> var2);

    protected Optional<class_2596<?>> createRegisterTypePacket(class_2960 id, Collection<class_2960> ids) {
        if (ids.isEmpty()) {
            return Optional.empty();
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        boolean first = true;
        for (class_2960 a : ids) {
            if (!first) {
                buf.writeByte(0);
            } else {
                first = false;
            }
            buf.writeBytes(a.toString().getBytes(StandardCharsets.US_ASCII));
        }
        return Optional.of(this.toPacket(id, buf));
    }

    private boolean acceptRegisterType(class_2960 id, PacketContext context, class_2540 buf) {
        String s;
        HashSet<class_2960> ids = new HashSet<class_2960>();
        StringBuilder sb = new StringBuilder();
        int oldIndex = buf.readerIndex();
        while (buf.readerIndex() < buf.writerIndex()) {
            char c = (char)buf.readByte();
            if (c == '\u0000') {
                s = sb.toString();
                if (!s.isEmpty()) {
                    try {
                        ids.add(new class_2960(s));
                    }
                    catch (class_151 e) {
                        LOGGER.warn("Received invalid identifier in " + id + ": " + s + " (" + e.getLocalizedMessage() + ")");
                        LOGGER.trace((Object)e);
                    }
                }
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        buf.readerIndex(oldIndex);
        s = sb.toString();
        if (!s.isEmpty()) {
            ids.add(new class_2960(s));
        }
        Collection<class_2960> target = this.getIdCollectionFor(context);
        if (id.equals((Object)PacketTypes.UNREGISTER)) {
            target.removeAll(ids);
            this.onReceivedUnregisterPacket(context, ids);
        } else {
            target.addAll(ids);
            this.onReceivedRegisterPacket(context, ids);
        }
        return false;
    }

    public boolean accept(class_2960 id, PacketContext context, class_2540 buf) {
        if (id.equals((Object)PacketTypes.REGISTER) || id.equals((Object)PacketTypes.UNREGISTER)) {
            return this.acceptRegisterType(id, context, buf);
        }
        PacketConsumer consumer = this.consumerMap.get(id);
        if (consumer != null) {
            try {
                consumer.accept(context, buf);
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to handle packet " + id + "!", t);
            }
            return true;
        }
        return false;
    }
}

