/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.object.builder.v1.block;

import net.fabricmc.fabric.impl.object.builder.BlockSettingsInternals;
import net.fabricmc.fabric.impl.object.builder.FabricBlockInternals;
import net.fabricmc.fabric.mixin.object.builder.BlockSettingsAccessor;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.fabricmc.fabric.mixin.object.builder.BlockAccessor;

/**
 * Fabric's version of Block.Settings. Adds additional methods and hooks
 * not found in the original class.
 *
 * <p>To use it, simply replace Block.Settings.of() with
 * FabricBlockSettings.of().
 */
public class FabricBlockSettings extends class_2248.class_2251 {
	protected FabricBlockSettings(class_3614 material, class_3620 color) {
		super(material, color);
	}

	protected FabricBlockSettings(class_2248.class_2251 settings) {
		super(((BlockSettingsAccessor) settings).getMaterial(), ((BlockSettingsAccessor) settings).getMaterialColor());
		// Mostly Copied from vanilla's copy method
		BlockSettingsAccessor thisAccessor = (BlockSettingsAccessor) this;
		BlockSettingsAccessor otherAccessor = (BlockSettingsAccessor) settings;

		thisAccessor.setMaterial(otherAccessor.getMaterial());
		this.hardness(otherAccessor.getHardness());
		this.resistance(otherAccessor.getResistance());
		this.collidable(otherAccessor.getCollidable());
		thisAccessor.setRandomTicks(otherAccessor.getRandomTicks());
		this.method_9631(otherAccessor.getLuminance());
		thisAccessor.setMaterialColor(otherAccessor.getMaterialColor());
		this.method_9626(otherAccessor.getSoundGroup());
		this.method_9628(otherAccessor.getSlipperiness());
		thisAccessor.setDynamicBounds(otherAccessor.getDynamicBounds());

		// Now attempt to copy fabric specific data
		BlockSettingsInternals otherInternals = (BlockSettingsInternals) settings;
		FabricBlockInternals.ExtraData extraData = otherInternals.getExtraData();

		if (extraData != null) { // If present, populate the extra data on our new settings
			((BlockSettingsInternals) this).setExtraData(extraData);
		}
	}

	public static FabricBlockSettings method_9637(class_3614 material) {
		return method_9639(material, material.method_15803());
	}

	public static FabricBlockSettings method_9639(class_3614 material, class_3620 color) {
		return new FabricBlockSettings(material, color);
	}

	public static FabricBlockSettings method_9617(class_3614 material, class_1767 color) {
		return new FabricBlockSettings(material, color.method_7794());
	}

	public static FabricBlockSettings copyOf(class_2248 block) {
		BlockAccessor sourceAccessor = (BlockAccessor) block;

		FabricBlockSettings settings = method_9639(sourceAccessor.getMaterial(), sourceAccessor.getMaterialColor());
		BlockSettingsAccessor settingsAccessor = (BlockSettingsAccessor) settings;

		settingsAccessor.setMaterial(sourceAccessor.getMaterial());
		settings.hardness(sourceAccessor.getHardness());
		settings.resistance(sourceAccessor.getResistance());
		settings.collidable(sourceAccessor.getCollidable());
		settingsAccessor.setRandomTicks(sourceAccessor.getRandomTicks());
		settings.method_9631(sourceAccessor.getLightLevel());
		settingsAccessor.setMaterialColor(sourceAccessor.getMaterialColor());
		settings.method_9626(sourceAccessor.getSoundGroup());
		settings.method_9628(block.method_9499());
		settingsAccessor.setDynamicBounds(sourceAccessor.getDynamicBounds());

		// Now attempt to copy fabric specific data
		BlockSettingsInternals otherInternals = (BlockSettingsInternals) settings;
		FabricBlockInternals.ExtraData extraData = otherInternals.getExtraData();

		if (extraData != null) { // If present, populate the extra data on our new settings
			((BlockSettingsInternals) settings).setExtraData(extraData);
		}

		return settings;
	}

	public static FabricBlockSettings copyOf(class_2248.class_2251 settings) {
		return new FabricBlockSettings(settings);
	}

	@Override
	public FabricBlockSettings method_9634() {
		super.method_9634();
		return this;
	}

	@Override
	public FabricBlockSettings method_9628(float value) {
		super.method_9628(value);
		return this;
	}

	@Override
	public FabricBlockSettings method_9626(class_2498 group) {
		super.method_9626(group);
		return this;
	}

	@Override
	public FabricBlockSettings method_9631(int luminance) {
		super.method_9631(luminance);
		return this;
	}

	@Override
	public FabricBlockSettings method_9629(float hardness, float resistance) {
		super.method_9629(hardness, resistance);
		return this;
	}

	@Override
	public FabricBlockSettings method_9618() {
		super.method_9618();
		return this;
	}

	public FabricBlockSettings method_9632(float strength) {
		super.method_9632(strength);
		return this;
	}

	@Override
	public FabricBlockSettings method_9640() {
		super.method_9640();
		return this;
	}

	@Override
	public FabricBlockSettings method_16229() {
		super.method_16229();
		return this;
	}

	@Override
	public FabricBlockSettings method_16228(class_2248 block) {
		super.method_16228(block);
		return this;
	}

	/* FABRIC ADDITIONS*/

	public FabricBlockSettings hardness(float hardness) {
		((BlockSettingsAccessor) this).setHardness(hardness);
		return this;
	}

	public FabricBlockSettings resistance(float resistance) {
		((BlockSettingsAccessor) this).setResistance(Math.max(0.0F, resistance));
		return this;
	}

	public FabricBlockSettings drops(class_2960 dropTableId) {
		((BlockSettingsAccessor) this).setDropTableId(dropTableId);
		return this;
	}

	public FabricBlockSettings dynamicBounds() {
		((BlockSettingsAccessor) this).setDynamicBounds(true);
		return this;
	}

	/* FABRIC DELEGATE WRAPPERS */

	public FabricBlockSettings materialColor(class_3620 color) {
		((BlockSettingsAccessor) this).setMaterialColor(color);
		return this;
	}

	public FabricBlockSettings materialColor(class_1767 color) {
		return this.materialColor(color.method_7794());
	}

	public FabricBlockSettings collidable(boolean collidable) {
		((BlockSettingsAccessor) this).setCollidable(collidable);
		return this;
	}

	/* FABRIC HELPERS */

	public FabricBlockSettings breakByHand(boolean breakByHand) {
		FabricBlockInternals.computeExtraData(this).breakByHand(breakByHand);
		return this;
	}

	public FabricBlockSettings breakByTool(class_3494<class_1792> tag, int miningLevel) {
		FabricBlockInternals.computeExtraData(this).addMiningLevel(tag, miningLevel);
		return this;
	}

	public FabricBlockSettings breakByTool(class_3494<class_1792> tag) {
		return this.breakByTool(tag, 0);
	}
}
