/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.entity;

import net.fabricmc.fabric.impl.object.builder.FabricEntityType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_4048;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricEntityTypeBuilder<T extends class_1297> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_1311 category;
    private final class_1299.class_4049<T> function;
    private boolean saveable = true;
    private boolean summonable = true;
    private int trackingDistance = 5;
    private int updateIntervalTicks = 3;
    private Boolean alwaysUpdateVelocity;
    private boolean fireImmune = false;
    private boolean spawnableFarFromPlayer;
    private int maxDespawnDistance = 128;
    private int minDespawnDistance = 32;
    private class_4048 dimensions = class_4048.method_18384((float)-1.0f, (float)-1.0f);

    protected FabricEntityTypeBuilder(class_1311 category, class_1299.class_4049<T> function) {
        this.category = category;
        this.function = function;
        this.spawnableFarFromPlayer = category == class_1311.field_6294 || category == class_1311.field_17715;
    }

    public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 category) {
        return new FabricEntityTypeBuilder<T>(category, (t, w) -> null);
    }

    public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 category, class_1299.class_4049<T> function) {
        return new FabricEntityTypeBuilder<T>(category, function);
    }

    public FabricEntityTypeBuilder<T> disableSummon() {
        this.summonable = false;
        return this;
    }

    public FabricEntityTypeBuilder<T> disableSaving() {
        this.saveable = false;
        return this;
    }

    public FabricEntityTypeBuilder<T> fireImmune() {
        this.fireImmune = true;
        return this;
    }

    public FabricEntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.spawnableFarFromPlayer = true;
        return this;
    }

    public FabricEntityTypeBuilder<T> dimensions(class_4048 dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public FabricEntityTypeBuilder<T> maxDespawnDistance(int maxDespawnDistance) {
        this.maxDespawnDistance = maxDespawnDistance;
        return this;
    }

    public FabricEntityTypeBuilder<T> minDespawnDistance(int minDespawnDistance) {
        this.minDespawnDistance = minDespawnDistance;
        return this;
    }

    public FabricEntityTypeBuilder<T> trackable(int trackingDistanceBlocks, int updateIntervalTicks) {
        return this.trackable(trackingDistanceBlocks, updateIntervalTicks, true);
    }

    public FabricEntityTypeBuilder<T> trackable(int trackingDistanceBlocks, int updateIntervalTicks, boolean alwaysUpdateVelocity) {
        this.trackingDistance = trackingDistanceBlocks;
        this.updateIntervalTicks = updateIntervalTicks;
        this.alwaysUpdateVelocity = alwaysUpdateVelocity;
        return this;
    }

    public class_1299<T> build() {
        if (this.saveable) {
            // empty if block
        }
        FabricEntityType<T> type = new FabricEntityType<T>(this.function, this.category, this.saveable, this.summonable, this.fireImmune, this.spawnableFarFromPlayer, this.maxDespawnDistance, this.minDespawnDistance, this.dimensions, this.trackingDistance, this.updateIntervalTicks, this.alwaysUpdateVelocity);
        return type;
    }
}

