/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.block;

import net.fabricmc.fabric.impl.object.builder.BlockSettingsInternals;
import net.fabricmc.fabric.impl.object.builder.FabricBlockInternals;
import net.fabricmc.fabric.mixin.object.builder.BlockAccessor;
import net.fabricmc.fabric.mixin.object.builder.BlockSettingsAccessor;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;

public class FabricBlockSettings
extends class_2248.class_2251 {
    protected FabricBlockSettings(class_3614 material, class_3620 color) {
        super(material, color);
    }

    protected FabricBlockSettings(class_2248.class_2251 settings) {
        super(((BlockSettingsAccessor)settings).getMaterial(), ((BlockSettingsAccessor)settings).getMaterialColor());
        BlockSettingsAccessor thisAccessor = (BlockSettingsAccessor)((Object)this);
        BlockSettingsAccessor otherAccessor = (BlockSettingsAccessor)settings;
        thisAccessor.setMaterial(otherAccessor.getMaterial());
        this.hardness(otherAccessor.getHardness());
        this.resistance(otherAccessor.getResistance());
        this.collidable(otherAccessor.getCollidable());
        thisAccessor.setRandomTicks(otherAccessor.getRandomTicks());
        this.lightLevel(otherAccessor.getLuminance());
        thisAccessor.setMaterialColor(otherAccessor.getMaterialColor());
        this.sounds(otherAccessor.getSoundGroup());
        this.slipperiness(otherAccessor.getSlipperiness());
        this.velocityMultiplier(otherAccessor.getJumpVelocityMultiplier());
        thisAccessor.setDynamicBounds(otherAccessor.getDynamicBounds());
        thisAccessor.setOpaque(otherAccessor.getOpaque());
        BlockSettingsInternals otherInternals = (BlockSettingsInternals)settings;
        FabricBlockInternals.ExtraData extraData = otherInternals.getExtraData();
        if (extraData != null) {
            ((BlockSettingsInternals)((Object)this)).setExtraData(extraData);
        }
    }

    public static FabricBlockSettings of(class_3614 material) {
        return FabricBlockSettings.of(material, material.method_15803());
    }

    public static FabricBlockSettings of(class_3614 material, class_3620 color) {
        return new FabricBlockSettings(material, color);
    }

    public static FabricBlockSettings of(class_3614 material, class_1767 color) {
        return new FabricBlockSettings(material, color.method_7794());
    }

    public static FabricBlockSettings copyOf(class_2248 block) {
        BlockAccessor sourceAccessor = (BlockAccessor)block;
        FabricBlockSettings settings = FabricBlockSettings.of(sourceAccessor.getMaterial(), sourceAccessor.getMaterialColor());
        BlockSettingsAccessor settingsAccessor = (BlockSettingsAccessor)((Object)settings);
        settingsAccessor.setMaterial(sourceAccessor.getMaterial());
        settings.hardness(sourceAccessor.getHardness());
        settings.resistance(sourceAccessor.getResistance());
        settings.collidable(sourceAccessor.getCollidable());
        settingsAccessor.setRandomTicks(sourceAccessor.getRandomTicks());
        settings.lightLevel(sourceAccessor.getLightLevel());
        settingsAccessor.setMaterialColor(sourceAccessor.getMaterialColor());
        settings.sounds(sourceAccessor.getSoundGroup());
        settings.slipperiness(block.method_9499());
        settings.velocityMultiplier(block.method_23349());
        settingsAccessor.setDynamicBounds(sourceAccessor.getDynamicBounds());
        settingsAccessor.setOpaque(sourceAccessor.getOpaque());
        BlockSettingsInternals otherInternals = (BlockSettingsInternals)((Object)settings);
        FabricBlockInternals.ExtraData extraData = otherInternals.getExtraData();
        if (extraData != null) {
            ((BlockSettingsInternals)((Object)settings)).setExtraData(extraData);
        }
        return settings;
    }

    public static FabricBlockSettings copyOf(class_2248.class_2251 settings) {
        return new FabricBlockSettings(settings);
    }

    public FabricBlockSettings noCollision() {
        super.method_9634();
        return this;
    }

    public FabricBlockSettings nonOpaque() {
        super.method_22488();
        return this;
    }

    public FabricBlockSettings slipperiness(float value) {
        super.method_9628(value);
        return this;
    }

    public FabricBlockSettings velocityMultiplier(float velocityMultiplier) {
        super.method_23351(velocityMultiplier);
        return this;
    }

    public FabricBlockSettings jumpVelocityMultiplier(float jumpVelocityMultiplier) {
        super.method_23352(jumpVelocityMultiplier);
        return this;
    }

    public FabricBlockSettings sounds(class_2498 group) {
        super.method_9626(group);
        return this;
    }

    public FabricBlockSettings lightLevel(int luminance) {
        super.method_9631(luminance);
        return this;
    }

    public FabricBlockSettings strength(float hardness, float resistance) {
        super.method_9629(hardness, resistance);
        return this;
    }

    public FabricBlockSettings breakInstantly() {
        super.method_9618();
        return this;
    }

    public FabricBlockSettings strength(float strength) {
        super.method_9632(strength);
        return this;
    }

    public FabricBlockSettings ticksRandomly() {
        super.method_9640();
        return this;
    }

    public FabricBlockSettings dropsNothing() {
        super.method_16229();
        return this;
    }

    public FabricBlockSettings dropsLike(class_2248 block) {
        super.method_16228(block);
        return this;
    }

    public FabricBlockSettings hardness(float hardness) {
        ((BlockSettingsAccessor)((Object)this)).setHardness(hardness);
        return this;
    }

    public FabricBlockSettings resistance(float resistance) {
        ((BlockSettingsAccessor)((Object)this)).setResistance(Math.max(0.0f, resistance));
        return this;
    }

    public FabricBlockSettings drops(class_2960 dropTableId) {
        ((BlockSettingsAccessor)((Object)this)).setDropTableId(dropTableId);
        return this;
    }

    public FabricBlockSettings dynamicBounds() {
        ((BlockSettingsAccessor)((Object)this)).setDynamicBounds(true);
        return this;
    }

    public FabricBlockSettings materialColor(class_3620 color) {
        ((BlockSettingsAccessor)((Object)this)).setMaterialColor(color);
        return this;
    }

    public FabricBlockSettings materialColor(class_1767 color) {
        return this.materialColor(color.method_7794());
    }

    public FabricBlockSettings collidable(boolean collidable) {
        ((BlockSettingsAccessor)((Object)this)).setCollidable(collidable);
        return this;
    }

    public FabricBlockSettings breakByHand(boolean breakByHand) {
        FabricBlockInternals.computeExtraData(this).breakByHand(breakByHand);
        return this;
    }

    public FabricBlockSettings breakByTool(class_3494<class_1792> tag, int miningLevel) {
        FabricBlockInternals.computeExtraData(this).addMiningLevel(tag, miningLevel);
        return this;
    }

    public FabricBlockSettings breakByTool(class_3494<class_1792> tag) {
        return this.breakByTool(tag, 0);
    }
}

