/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.object.builder.v1.block;

import java.util.function.ToIntFunction;
import net.fabricmc.fabric.impl.object.builder.BlockSettingsInternals;
import net.fabricmc.fabric.impl.object.builder.FabricBlockInternals;
import net.fabricmc.fabric.mixin.object.builder.AbstractBlockAccessor;
import net.fabricmc.fabric.mixin.object.builder.AbstractBlockSettingsAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

/**
 * Fabric's version of Block.Settings. Adds additional methods and hooks
 * not found in the original class.
 *
 * <p>To use it, simply replace Block.Settings.of() with
 * FabricBlockSettings.of().
 */
public class FabricBlockSettings extends class_4970.class_2251 {
	protected FabricBlockSettings(class_3614 material, class_3620 ) {
		super(material, );
	}

	protected FabricBlockSettings(class_4970.class_2251 settings) {
		super(((AbstractBlockSettingsAccessor) settings).getMaterial(), ((AbstractBlockSettingsAccessor) settings).getMapColorProvider());
		// Mostly Copied from vanilla's copy method
		// Note: If new methods are added to Block settings, an accessor must be added here
		AbstractBlockSettingsAccessor thisAccessor = (AbstractBlockSettingsAccessor) this;
		AbstractBlockSettingsAccessor otherAccessor = (AbstractBlockSettingsAccessor) settings;

		thisAccessor.setMaterial(otherAccessor.getMaterial());
		this.method_36557(otherAccessor.getHardness());
		this.method_36558(otherAccessor.getResistance());
		this.collidable(otherAccessor.getCollidable());
		thisAccessor.setRandomTicks(otherAccessor.getRandomTicks());
		this.method_9631(otherAccessor.getLuminance());
		thisAccessor.setMapColorProvider(otherAccessor.getMapColorProvider());
		this.method_9626(otherAccessor.getSoundGroup());
		this.method_9628(otherAccessor.getSlipperiness());
		this.method_23351(otherAccessor.getVelocityMultiplier());
		thisAccessor.setDynamicBounds(otherAccessor.getDynamicBounds());
		thisAccessor.setOpaque(otherAccessor.getOpaque());
		thisAccessor.setIsAir(otherAccessor.getIsAir());
		thisAccessor.setToolRequired(otherAccessor.isToolRequired());

		// Now attempt to copy fabric specific data
		BlockSettingsInternals otherInternals = (BlockSettingsInternals) settings;
		FabricBlockInternals.ExtraData extraData = otherInternals.getExtraData();

		if (extraData != null) { // If present, populate the extra data on our new settings
			((BlockSettingsInternals) this).setExtraData(extraData);
		}
	}

	public static FabricBlockSettings method_9637(class_3614 ) {
		return method_9639(, .method_15803());
	}

	public static FabricBlockSettings method_9639(class_3614 , class_3620 ) {
		return new FabricBlockSettings(, );
	}

	public static FabricBlockSettings method_9617(class_3614 , class_1767 ) {
		return new FabricBlockSettings(, .method_7794());
	}

	public static FabricBlockSettings copyOf(class_4970 block) {
		return new FabricBlockSettings(((AbstractBlockAccessor) block).getSettings());
	}

	public static FabricBlockSettings copyOf(class_4970.class_2251 settings) {
		return new FabricBlockSettings(settings);
	}

	@Override
	public FabricBlockSettings method_9634() {
		super.method_9634();
		return this;
	}

	@Override
	public FabricBlockSettings method_22488() {
		super.method_22488();
		return this;
	}

	@Override
	public FabricBlockSettings method_9628(float value) {
		super.method_9628(value);
		return this;
	}

	@Override
	public FabricBlockSettings method_23351(float velocityMultiplier) {
		super.method_23351(velocityMultiplier);
		return this;
	}

	@Override
	public FabricBlockSettings method_23352(float jumpVelocityMultiplier) {
		super.method_23352(jumpVelocityMultiplier);
		return this;
	}

	@Override
	public FabricBlockSettings method_9626(class_2498 group) {
		super.method_9626(group);
		return this;
	}

	/**
	 * @deprecated Please use {@link FabricBlockSettings#method_9631(ToIntFunction)}.
	 */
	public FabricBlockSettings lightLevel(ToIntFunction<class_2680> levelFunction) {
		return this.method_9631(levelFunction);
	}

	@Override
	public FabricBlockSettings method_9631(ToIntFunction<class_2680> luminanceFunction) {
		super.method_9631(luminanceFunction);
		return this;
	}

	@Override
	public FabricBlockSettings method_9629(float hardness, float ) {
		super.method_9629(hardness, );
		return this;
	}

	@Override
	public FabricBlockSettings method_9618() {
		super.method_9618();
		return this;
	}

	public FabricBlockSettings method_9632(float strength) {
		super.method_9632(strength);
		return this;
	}

	@Override
	public FabricBlockSettings method_9640() {
		super.method_9640();
		return this;
	}

	@Override
	public FabricBlockSettings method_9624() {
		super.method_9624();
		return this;
	}

	@Override
	public FabricBlockSettings method_16229() {
		super.method_16229();
		return this;
	}

	@Override
	public FabricBlockSettings method_16228(class_2248 block) {
		super.method_16228(block);
		return this;
	}

	@Override
	public FabricBlockSettings method_26250() {
		super.method_26250();
		return this;
	}

	@Override
	public FabricBlockSettings method_26235(class_4970.class_4972<class_1299<?>> predicate) {
		super.method_26235(predicate);
		return this;
	}

	@Override
	public FabricBlockSettings method_26236(class_4970.class_4973 predicate) {
		super.method_26236(predicate);
		return this;
	}

	@Override
	public FabricBlockSettings method_26243(class_4970.class_4973 predicate) {
		super.method_26243(predicate);
		return this;
	}

	@Override
	public FabricBlockSettings method_26245(class_4970.class_4973 predicate) {
		super.method_26245(predicate);
		return this;
	}

	@Override
	public FabricBlockSettings method_26247(class_4970.class_4973 predicate) {
		super.method_26247(predicate);
		return this;
	}

	@Override
	public FabricBlockSettings method_26249(class_4970.class_4973 predicate) {
		super.method_26249(predicate);
		return this;
	}

	/* FABRIC ADDITIONS*/

	/**
	 * @deprecated Please use {@link FabricBlockSettings#luminance(int)}.
	 */
	@Deprecated
	public FabricBlockSettings lightLevel(int lightLevel) {
		this.luminance(lightLevel);
		return this;
	}

	public FabricBlockSettings luminance(int luminance) {
		this.method_9631(ignored -> luminance);
		return this;
	}

	public FabricBlockSettings method_36557(float hardness) {
		((AbstractBlockSettingsAccessor) this).setHardness(hardness);
		return this;
	}

	public FabricBlockSettings method_36558(float resistance) {
		((AbstractBlockSettingsAccessor) this).setResistance(Math.max(0.0F, resistance));
		return this;
	}

	public FabricBlockSettings drops(class_2960 dropTableId) {
		((AbstractBlockSettingsAccessor) this).setLootTableId(dropTableId);
		return this;
	}

	/**
	 * Make the block require tool to drop and slows down mining speed if the incorrect tool is used.
	 */
	@Override
	public FabricBlockSettings method_29292() {
		super.method_29292();
		return this;
	}

	/* FABRIC DELEGATE WRAPPERS */

	/**
	 * @deprecated Please migrate to {@link FabricBlockSettings#method_31710(class_3620)}
	 */
	@Deprecated
	public FabricBlockSettings materialColor(class_3620 color) {
		return this.method_31710(color);
	}

	/**
	 * @deprecated Please migrate to {@link FabricBlockSettings#mapColor(class_1767)}
	 */
	@Deprecated
	public FabricBlockSettings materialColor(class_1767 color) {
		return this.mapColor(color);
	}

	public FabricBlockSettings method_31710(class_3620 color) {
		((AbstractBlockSettingsAccessor) this).setMapColorProvider(ignored -> color);
		return this;
	}

	public FabricBlockSettings mapColor(class_1767 color) {
		return this.method_31710(color.method_7794());
	}

	public FabricBlockSettings collidable(boolean collidable) {
		((AbstractBlockSettingsAccessor) this).setCollidable(collidable);
		return this;
	}

	/* FABRIC HELPERS */

	/**
	 * Makes the block breakable by any tool if {@code breakByHand} is set to true.
	 */
	public FabricBlockSettings breakByHand(boolean breakByHand) {
		FabricBlockInternals.computeExtraData(this).breakByHand(breakByHand);
		return this;
	}

	/**
	 * Please make the block require a tool if you plan to disable drops and slow the breaking down using the
	 * incorrect tool by using {@link FabricBlockSettings#method_29292()}.
	 *
	 * @deprecated Replaced by {@code mineable} tags. See fabric-mining-level-api-v1 for further details.
	 */
	@Deprecated(forRemoval = true)
	public FabricBlockSettings breakByTool(class_3494<class_1792> tag, int miningLevel) {
		FabricBlockInternals.computeExtraData(this).addMiningLevel(tag, miningLevel);
		return this;
	}

	/**
	 * Please make the block require a tool if you plan to disable drops and slow the breaking down using the
	 * incorrect tool by using {@link FabricBlockSettings#method_29292()}.
	 *
	 * @deprecated Replaced by {@code mineable} tags. See fabric-mining-level-api-v1 for further details.S
	 */
	@Deprecated(forRemoval = true)
	public FabricBlockSettings breakByTool(class_3494<class_1792> tag) {
		return this.breakByTool(tag, 0);
	}
}
