/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.object.builder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.mixin.object.builder.TradeOffersAccessor;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import org.apache.commons.lang3.ArrayUtils;

public final class TradeOfferInternals {
    public static Map<class_3852, Int2ObjectMap<class_3853.class_1652[]>> DEFAULT_VILLAGER_OFFERS;
    public static Int2ObjectMap<class_3853.class_1652[]> DEFAULT_WANDERING_TRADER_OFFERS;
    private static final Map<class_3852, Int2ObjectMap<class_3853.class_1652[]>> VILLAGER_TRADE_FACTORIES;
    private static final Int2ObjectMap<class_3853.class_1652[]> WANDERING_TRADER_FACTORIES;

    private TradeOfferInternals() {
    }

    public static void registerVillagerOffers(class_3852 profession, int level, Consumer<List<class_3853.class_1652>> factory) {
        ArrayList list = new ArrayList();
        factory.accept(list);
        Object[] additionalEntries = list.toArray(new class_3853.class_1652[0]);
        Int2ObjectMap professionEntry = VILLAGER_TRADE_FACTORIES.computeIfAbsent(profession, p -> new Int2ObjectOpenHashMap());
        Object[] currentEntries = (class_3853.class_1652[])professionEntry.computeIfAbsent(level, l -> new class_3853.class_1652[0]);
        class_3853.class_1652[] newEntries = (class_3853.class_1652[])ArrayUtils.addAll((Object[])additionalEntries, (Object[])currentEntries);
        professionEntry.put(level, (Object)newEntries);
        TradeOfferInternals.refreshOffers();
    }

    public static void registerWanderingTraderOffers(int level, Consumer<List<class_3853.class_1652>> factory) {
        ArrayList list = new ArrayList();
        factory.accept(list);
        Object[] additionalEntries = list.toArray(new class_3853.class_1652[0]);
        Object[] currentEntries = (class_3853.class_1652[])DEFAULT_WANDERING_TRADER_OFFERS.computeIfAbsent(level, key -> new class_3853.class_1652[0]);
        class_3853.class_1652[] newEntries = (class_3853.class_1652[])ArrayUtils.addAll((Object[])additionalEntries, (Object[])currentEntries);
        DEFAULT_WANDERING_TRADER_OFFERS.put(level, (Object)newEntries);
        TradeOfferInternals.refreshOffers();
    }

    public static void refreshOffers() {
        TradeOfferInternals.refreshVillagerOffers();
        TradeOfferInternals.refreshWanderingTraderOffers();
    }

    private static void refreshVillagerOffers() {
        HashMap<class_3852, Int2ObjectMap<class_3853.class_1652[]>> trades = new HashMap<class_3852, Int2ObjectMap<class_3853.class_1652[]>>(DEFAULT_VILLAGER_OFFERS);
        for (Map.Entry<class_3852, Int2ObjectMap<class_3853.class_1652[]>> tradeFactoryEntry : VILLAGER_TRADE_FACTORIES.entrySet()) {
            Int2ObjectMap leveledFactoryMap = trades.computeIfAbsent(tradeFactoryEntry.getKey(), k -> new Int2ObjectOpenHashMap());
            Int2ObjectMap<class_3853.class_1652[]> value = tradeFactoryEntry.getValue();
            IntIterator intIterator = value.keySet().iterator();
            while (intIterator.hasNext()) {
                int level = (Integer)intIterator.next();
                Object[] factories = (class_3853.class_1652[])value.get(level);
                if (factories == null) continue;
                Int2ObjectMap resultMap = trades.computeIfAbsent(tradeFactoryEntry.getKey(), key -> new Int2ObjectOpenHashMap());
                resultMap.put(level, (Object)ArrayUtils.addAll((Object[])((Object[])leveledFactoryMap.computeIfAbsent(level, key -> new class_3853.class_1652[0])), (Object[])factories));
            }
        }
        TradeOffersAccessor.setVillagerTradeMap(trades);
    }

    private static void refreshWanderingTraderOffers() {
        Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap(DEFAULT_WANDERING_TRADER_OFFERS);
        IntIterator intIterator = WANDERING_TRADER_FACTORIES.keySet().iterator();
        while (intIterator.hasNext()) {
            int level = (Integer)intIterator.next();
            Object[] factories = (class_3853.class_1652[])WANDERING_TRADER_FACTORIES.get(level);
            trades.put(level, (Object)ArrayUtils.addAll((Object[])factories, (Object[])((Object[])trades.computeIfAbsent(level, key -> new class_3853.class_1652[0]))));
        }
        TradeOffersAccessor.setWanderingTraderTradeMap((Int2ObjectMap<class_3853.class_1652[]>)trades);
    }

    static {
        VILLAGER_TRADE_FACTORIES = new HashMap<class_3852, Int2ObjectMap<class_3853.class_1652[]>>();
        WANDERING_TRADER_FACTORIES = new Int2ObjectOpenHashMap();
        class_3853.field_17067.getClass();
    }
}

