/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.object.builder;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_4048;

public class FabricEntityType<T extends class_1297> extends class_1299<T> {
	private final int maxTrackDistance, trackTickInterval;
	private final Boolean alwaysUpdateVelocity;

	public FabricEntityType(class_4049<T> entityType$EntityFactory_1, class_1311 entityCategory_1, boolean boolean_1, boolean boolean_2, boolean boolean_3, boolean boolean_4, class_4048 entitySize_1, int maxTrackDistance, int trackTickInterval, Boolean alwaysUpdateVelocity) {
		super(entityType$EntityFactory_1, entityCategory_1, boolean_1, boolean_2, boolean_3, boolean_4, entitySize_1);
		this.maxTrackDistance = maxTrackDistance;
		this.trackTickInterval = trackTickInterval;
		this.alwaysUpdateVelocity = alwaysUpdateVelocity;
	}

	@Override
	public int method_18387() {
		if (maxTrackDistance != -1) {
			return (maxTrackDistance + 15) / 16;
		}

		return super.method_18387();
	}

	@Override
	public int method_18388() {
		if (trackTickInterval != -1) {
			return trackTickInterval;
		}

		return super.method_18388();
	}

	@Override
	public boolean method_18389() {
		if (alwaysUpdateVelocity != null) {
			return alwaysUpdateVelocity;
		}

		return super.method_18389();
	}
}
