/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import java.util.Map;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.impl.object.builder.TradeOfferInternals;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

@Mixin(class_3853.class)
public abstract class TradeOffersMixin {
	@Shadow
	@Final
	public static Map<class_3852, Int2ObjectMap<class_3853.class_1652[]>> PROFESSION_TO_LEVELED_TRADE;
	@Shadow
	@Final
	public static Int2ObjectMap<class_3853.class_1652[]> WANDERING_TRADER_TRADES;

	static {
		// Cache the original trade lists
		TradeOfferInternals.DEFAULT_VILLAGER_OFFERS = PROFESSION_TO_LEVELED_TRADE;
		TradeOfferInternals.DEFAULT_WANDERING_TRADER_OFFERS = WANDERING_TRADER_TRADES;
	}
}
