/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.object.builder;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_4048;

public class FabricEntityType<T extends class_1297> extends class_1299<T> {
	private final Boolean alwaysUpdateVelocity;

	public FabricEntityType(class_1299.class_4049<T> factory, class_1311 spawnGroup, boolean bl, boolean summonable, boolean fireImmune, boolean spawnableFarFromPlayer, class_4048 entityDimensions, int maxTrackDistance, int trackTickInterval, Boolean alwaysUpdateVelocity) {
		super(factory, spawnGroup, bl, summonable, fireImmune, spawnableFarFromPlayer, entityDimensions, (maxTrackDistance + 15) / 16, trackTickInterval);
		this.alwaysUpdateVelocity = alwaysUpdateVelocity;
	}

	@Override
	public boolean method_18389() {
		if (alwaysUpdateVelocity != null) {
			return alwaysUpdateVelocity;
		}

		return super.method_18389();
	}
}
