/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.entity;

import com.google.common.collect.ImmutableSet;
import net.fabricmc.fabric.impl.object.builder.FabricEntityType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2248;
import net.minecraft.class_4048;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricEntityTypeBuilder<T extends class_1297> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_1311 spawnGroup;
    private final class_1299.class_4049<T> function;
    private boolean saveable = true;
    private boolean summonable = true;
    private int trackingDistance = 5;
    private int updateIntervalTicks = 3;
    private Boolean alwaysUpdateVelocity;
    private boolean fireImmune = false;
    private boolean spawnableFarFromPlayer;
    private class_4048 dimensions = class_4048.method_18384((float)-1.0f, (float)-1.0f);
    private ImmutableSet<class_2248> specificSpawnBlocks = ImmutableSet.of();

    protected FabricEntityTypeBuilder(class_1311 spawnGroup, class_1299.class_4049<T> function) {
        this.spawnGroup = spawnGroup;
        this.function = function;
        this.spawnableFarFromPlayer = spawnGroup == class_1311.field_6294 || spawnGroup == class_1311.field_17715;
    }

    public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 spawnGroup) {
        return new FabricEntityTypeBuilder<T>(spawnGroup, (t, w) -> null);
    }

    public static <T extends class_1297> FabricEntityTypeBuilder<T> create(class_1311 spawnGroup, class_1299.class_4049<T> function) {
        return new FabricEntityTypeBuilder<T>(spawnGroup, function);
    }

    public FabricEntityTypeBuilder<T> disableSummon() {
        this.summonable = false;
        return this;
    }

    public FabricEntityTypeBuilder<T> disableSaving() {
        this.saveable = false;
        return this;
    }

    public FabricEntityTypeBuilder<T> fireImmune() {
        this.fireImmune = true;
        return this;
    }

    public FabricEntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.spawnableFarFromPlayer = true;
        return this;
    }

    public FabricEntityTypeBuilder<T> dimensions(class_4048 dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public FabricEntityTypeBuilder<T> trackable(int trackingDistanceBlocks, int updateIntervalTicks) {
        return this.trackable(trackingDistanceBlocks, updateIntervalTicks, true);
    }

    public FabricEntityTypeBuilder<T> trackable(int trackingDistanceBlocks, int updateIntervalTicks, boolean alwaysUpdateVelocity) {
        this.trackingDistance = trackingDistanceBlocks;
        this.updateIntervalTicks = updateIntervalTicks;
        this.alwaysUpdateVelocity = alwaysUpdateVelocity;
        return this;
    }

    public FabricEntityTypeBuilder<T> specificSpawnBlocks(class_2248 ... blocks) {
        this.specificSpawnBlocks = ImmutableSet.copyOf((Object[])blocks);
        return this;
    }

    public class_1299<T> build() {
        if (this.saveable) {
            // empty if block
        }
        FabricEntityType<T> type = new FabricEntityType<T>(this.function, this.spawnGroup, this.saveable, this.summonable, this.fireImmune, this.spawnableFarFromPlayer, this.specificSpawnBlocks, this.dimensions, this.trackingDistance, this.updateIntervalTicks, this.alwaysUpdateVelocity);
        return type;
    }
}

