/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.object.builder;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.impl.object.builder.BlockSettingsInternals;
import net.fabricmc.fabric.impl.tool.attribute.ToolManagerImpl;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_3494;
import net.minecraft.class_4970;

public final class FabricBlockInternals {
    private FabricBlockInternals() {
    }

    public static ExtraData computeExtraData(class_4970.class_2251 settings) {
        BlockSettingsInternals internals = (BlockSettingsInternals)settings;
        if (internals.getExtraData() == null) {
            internals.setExtraData(new ExtraData(settings));
        }
        return internals.getExtraData();
    }

    public static void onBuild(class_4970.class_2251 settings, class_2248 block) {
        ExtraData data = ((BlockSettingsInternals)settings).getExtraData();
        if (data != null) {
            if (data.breakByHand != null) {
                ToolManagerImpl.entry((class_2248)block).setBreakByHand(data.breakByHand.booleanValue());
            }
            for (MiningLevel tml : data.miningLevels) {
                ToolManagerImpl.entry((class_2248)block).putBreakByTool(tml.tag, tml.level);
            }
        }
    }

    public static final class MiningLevel {
        private final class_3494<class_1792> tag;
        private final int level;

        MiningLevel(class_3494<class_1792> tag, int level) {
            this.tag = tag;
            this.level = level;
        }
    }

    public static final class ExtraData {
        private final List<MiningLevel> miningLevels = new ArrayList<MiningLevel>();
        private Boolean breakByHand;

        public ExtraData(class_4970.class_2251 settings) {
        }

        public void breakByHand(boolean breakByHand) {
            this.breakByHand = breakByHand;
        }

        public void addMiningLevel(class_3494<class_1792> tag, int level) {
            this.miningLevels.add(new MiningLevel(tag, level));
        }
    }
}

