/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.object.builder.v1.block;

import net.fabricmc.fabric.mixin.object.builder.MaterialBuilderAccessor;
import net.minecraft.class_1767;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_3620;

public class FabricMaterialBuilder extends class_3614.class_3615 {
	public FabricMaterialBuilder(class_3620 color) {
		super(color);
	}

	public FabricMaterialBuilder(class_1767 color) {
		this(color.method_7794());
	}

	@Override
	public FabricMaterialBuilder burnable() {
		super.method_15807();
		return this;
	}

	public FabricMaterialBuilder pistonBehavior(class_3619 behavior) {
		((MaterialBuilderAccessor) this).setPistonBehavior(behavior);
		return this;
	}

	public FabricMaterialBuilder lightPassesThrough() {
		((MaterialBuilderAccessor) this).invokeLightPassesThrough();
		return this;
	}

	@Override
	public FabricMaterialBuilder destroyedByPiston() {
		super.method_15809();
		return this;
	}

	@Override
	public FabricMaterialBuilder blocksPistons() {
		super.method_15816();
		return this;
	}

	@Override
	public FabricMaterialBuilder allowsMovement() {
		super.method_15811();
		return this;
	}

	@Override
	public FabricMaterialBuilder liquid() {
		super.method_15810();
		return this;
	}

	@Override
	public class_3614.class_3615 method_15806() {
		super.method_15806();
		return this;
	}

	@Override
	public FabricMaterialBuilder replaceable() {
		super.method_15815();
		return this;
	}
}
