/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(class_4970.class_2251.class)
public interface AbstractBlockSettingsAccessor {
	/* GETTERS */
	@Accessor
	class_3614 getMaterial();

	@Accessor
	float getHardness();

	@Accessor
	float getResistance();

	@Accessor
	boolean getCollidable();

	@Accessor
	boolean getRandomTicks();

	@Accessor
	ToIntFunction<class_2680> getLuminance();

	@Accessor
	Function<class_2680, class_3620> getMaterialColorFactory();

	@Accessor
	class_2498 getSoundGroup();

	@Accessor
	float getSlipperiness();

	@Accessor
	float getVelocityMultiplier();

	@Accessor
	boolean getDynamicBounds();

	@Accessor
	boolean getOpaque();

	@Accessor
	boolean getIsAir();

	/* SETTERS */
	@Accessor
	void setMaterial(class_3614 material);

	@Accessor
	void setHardness(float hardness);

	@Accessor
	void setResistance(float resistance);

	@Accessor
	void setCollidable(boolean collidable);

	@Accessor
	void setRandomTicks(boolean ticksRandomly);

	@Accessor
	void setMaterialColorFactory(Function<class_2680, class_3620> materialColorFunction);

	@Accessor
	void setDynamicBounds(boolean dynamicBounds);

	@Accessor
	void setOpaque(boolean opaque);

	@Accessor
	void setIsAir(boolean isAir);

	@Accessor
	void setLootTableId(class_2960 lootTableId);
	/* INVOKERS */

	@Invoker
	class_2248.Settings invokeSounds(class_2498 group);

	@Invoker
	class_2248.Settings invokeLightLevel(ToIntFunction<class_2680> lightLevelFunction);

	@Invoker
	class_2248.Settings invokeBreakInstantly();

	@Invoker
	class_2248.Settings invokeStrength(float strength);

	@Invoker
	class_2248.Settings invokeTicksRandomly();

	@Invoker
	class_2248.Settings invokeDropsNothing();
}
