/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.block;

import java.util.function.ToIntFunction;
import net.fabricmc.fabric.impl.object.builder.BlockSettingsInternals;
import net.fabricmc.fabric.impl.object.builder.FabricBlockInternals;
import net.fabricmc.fabric.mixin.object.builder.AbstractBlockAccessor;
import net.fabricmc.fabric.mixin.object.builder.AbstractBlockSettingsAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class FabricBlockSettings
extends class_4970.class_2251 {
    protected FabricBlockSettings(class_3614 material, class_3620 color) {
        super(material, color);
    }

    protected FabricBlockSettings(class_4970.class_2251 settings) {
        super(((AbstractBlockSettingsAccessor)settings).getMaterial(), ((AbstractBlockSettingsAccessor)settings).getMaterialColorFactory());
        AbstractBlockSettingsAccessor thisAccessor = (AbstractBlockSettingsAccessor)((Object)this);
        AbstractBlockSettingsAccessor otherAccessor = (AbstractBlockSettingsAccessor)settings;
        thisAccessor.setMaterial(otherAccessor.getMaterial());
        this.hardness(otherAccessor.getHardness());
        this.resistance(otherAccessor.getResistance());
        this.collidable(otherAccessor.getCollidable());
        thisAccessor.setRandomTicks(otherAccessor.getRandomTicks());
        this.lightLevel(otherAccessor.getLuminance());
        thisAccessor.setMaterialColorFactory(otherAccessor.getMaterialColorFactory());
        this.sounds(otherAccessor.getSoundGroup());
        this.slipperiness(otherAccessor.getSlipperiness());
        this.velocityMultiplier(otherAccessor.getVelocityMultiplier());
        thisAccessor.setDynamicBounds(otherAccessor.getDynamicBounds());
        thisAccessor.setOpaque(otherAccessor.getOpaque());
        thisAccessor.setIsAir(otherAccessor.getIsAir());
        BlockSettingsInternals otherInternals = (BlockSettingsInternals)settings;
        FabricBlockInternals.ExtraData extraData = otherInternals.getExtraData();
        if (extraData != null) {
            ((BlockSettingsInternals)((Object)this)).setExtraData(extraData);
        }
    }

    public static FabricBlockSettings of(class_3614 material) {
        return FabricBlockSettings.of(material, material.method_15803());
    }

    public static FabricBlockSettings of(class_3614 material, class_3620 color) {
        return new FabricBlockSettings(material, color);
    }

    public static FabricBlockSettings of(class_3614 material, class_1767 color) {
        return new FabricBlockSettings(material, color.method_7794());
    }

    public static FabricBlockSettings copyOf(class_4970 block) {
        return new FabricBlockSettings(((AbstractBlockAccessor)block).getSettings());
    }

    public static FabricBlockSettings copyOf(class_4970.class_2251 settings) {
        return new FabricBlockSettings(settings);
    }

    public FabricBlockSettings noCollision() {
        super.method_9634();
        return this;
    }

    public FabricBlockSettings nonOpaque() {
        super.method_22488();
        return this;
    }

    public FabricBlockSettings slipperiness(float value) {
        super.method_9628(value);
        return this;
    }

    public FabricBlockSettings velocityMultiplier(float velocityMultiplier) {
        super.method_23351(velocityMultiplier);
        return this;
    }

    public FabricBlockSettings jumpVelocityMultiplier(float jumpVelocityMultiplier) {
        super.method_23352(jumpVelocityMultiplier);
        return this;
    }

    public FabricBlockSettings sounds(class_2498 group) {
        super.method_9626(group);
        return this;
    }

    public FabricBlockSettings lightLevel(ToIntFunction<class_2680> levelFunction) {
        super.method_9631(levelFunction);
        return this;
    }

    public FabricBlockSettings strength(float hardness, float resistance) {
        super.method_9629(hardness, resistance);
        return this;
    }

    public FabricBlockSettings breakInstantly() {
        super.method_9618();
        return this;
    }

    public FabricBlockSettings strength(float strength) {
        super.method_9632(strength);
        return this;
    }

    public FabricBlockSettings ticksRandomly() {
        super.method_9640();
        return this;
    }

    public FabricBlockSettings dynamicBounds() {
        super.method_9624();
        return this;
    }

    public FabricBlockSettings dropsNothing() {
        super.method_16229();
        return this;
    }

    public FabricBlockSettings dropsLike(class_2248 block) {
        super.method_16228(block);
        return this;
    }

    public FabricBlockSettings air() {
        super.method_26250();
        return this;
    }

    public FabricBlockSettings allowsSpawning(class_4970.class_4972<class_1299<?>> predicate) {
        super.method_26235(predicate);
        return this;
    }

    public FabricBlockSettings solidBlock(class_4970.class_4973 predicate) {
        super.method_26236(predicate);
        return this;
    }

    public FabricBlockSettings suffocates(class_4970.class_4973 predicate) {
        super.method_26243(predicate);
        return this;
    }

    public FabricBlockSettings blockVision(class_4970.class_4973 predicate) {
        super.method_26245(predicate);
        return this;
    }

    public FabricBlockSettings postProcess(class_4970.class_4973 predicate) {
        super.method_26247(predicate);
        return this;
    }

    public FabricBlockSettings emissiveLighting(class_4970.class_4973 predicate) {
        super.method_26249(predicate);
        return this;
    }

    public FabricBlockSettings lightLevel(int lightLevel) {
        this.lightLevel(ignored -> lightLevel);
        return this;
    }

    public FabricBlockSettings hardness(float hardness) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setHardness(hardness);
        return this;
    }

    public FabricBlockSettings resistance(float resistance) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setResistance(Math.max(0.0f, resistance));
        return this;
    }

    public FabricBlockSettings drops(class_2960 dropTableId) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setLootTableId(dropTableId);
        return this;
    }

    public FabricBlockSettings requiresTool() {
        super.method_29292();
        return this;
    }

    public FabricBlockSettings materialColor(class_3620 color) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setMaterialColorFactory(ignored -> color);
        return this;
    }

    public FabricBlockSettings materialColor(class_1767 color) {
        return this.materialColor(color.method_7794());
    }

    public FabricBlockSettings collidable(boolean collidable) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setCollidable(collidable);
        return this;
    }

    public FabricBlockSettings breakByHand(boolean breakByHand) {
        FabricBlockInternals.computeExtraData(this).breakByHand(breakByHand);
        return this;
    }

    public FabricBlockSettings breakByTool(class_3494<class_1792> tag, int miningLevel) {
        FabricBlockInternals.computeExtraData(this).addMiningLevel(tag, miningLevel);
        return this;
    }

    public FabricBlockSettings breakByTool(class_3494<class_1792> tag) {
        return this.breakByTool(tag, 0);
    }
}

